/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.AgendaItemImpl;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.mockito.Mockito;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;

public abstract class AbstractScoreHolderTest<Score_ extends Score<Score_>> {
    protected static final Object DEFAULT_JUSTIFICATION = new Object();
    protected static final Object OTHER_JUSTIFICATION = new Object();
    protected static final Object UNDO_JUSTIFICATION = new Object();

    protected RuleContext mockRuleContext(String ruleName, Object ... justifications) {
        Rule rule = this.mockRule(ruleName);
        return this.mockRuleContext(rule, justifications);
    }

    protected RuleContext mockRuleContext(Rule rule, Object ... justifications) {
        if (justifications.length == 0) {
            justifications = new Object[]{DEFAULT_JUSTIFICATION};
        }
        final List<Object> justificationList = Arrays.asList(justifications);
        RuleContext kcontext = (RuleContext)Mockito.mock(RuleContext.class);
        AgendaItemImpl agendaItem = new AgendaItemImpl(){

            public List<Object> getObjects() {
                return justificationList;
            }

            public List<Object> getObjectsDeep() {
                return justificationList;
            }
        };
        Mockito.when((Object)kcontext.getMatch()).thenReturn((Object)agendaItem);
        Mockito.when((Object)kcontext.getRule()).thenReturn((Object)rule);
        return kcontext;
    }

    protected Rule mockRule(String ruleName) {
        Rule rule = (Rule)Mockito.mock(Rule.class);
        Mockito.when((Object)rule.getPackageName()).thenReturn((Object)this.getClass().getPackage().getName());
        Mockito.when((Object)rule.getName()).thenReturn((Object)ruleName);
        return rule;
    }

    protected void callOnUpdate(RuleContext ruleContext) {
        AgendaItem agendaItem = (AgendaItem)ruleContext.getMatch();
        agendaItem.getCallback().run();
    }

    protected void callOnDelete(RuleContext ruleContext) {
        AgendaItem agendaItem = (AgendaItem)ruleContext.getMatch();
        agendaItem.getCallback().run();
    }

    protected ConstraintMatchTotal<Score_> findConstraintMatchTotal(AbstractScoreHolder<Score_> scoreHolder, String ruleName) {
        Collection constraintMatchTotals = scoreHolder.getConstraintMatchTotalMap().values();
        Optional<ConstraintMatchTotal> first = constraintMatchTotals.stream().filter(constraintMatchTotal -> constraintMatchTotal.getConstraintName().equals(ruleName)).findFirst();
        return first.orElse(null);
    }

    @Test
    void illegalStateExceptionThrownWhenConstraintMatchNotEnabled() {
        AbstractScoreHolder<SimpleScore> scoreHolder = this.buildScoreHolder(false);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> scoreHolder.getConstraintMatchTotalMap()).withMessageContaining("constraintMatchEnabled");
    }

    @Test
    void constraintMatchTotalsNeverNull() {
        Assertions.assertThat((Map)this.buildScoreHolder(true).getConstraintMatchTotalMap()).isNotNull();
    }

    private AbstractScoreHolder<SimpleScore> buildScoreHolder(boolean constraintMatchEnabled) {
        return new AbstractScoreHolder<SimpleScore>(constraintMatchEnabled){

            public void penalize(RuleContext kcontext) {
                throw new UnsupportedOperationException();
            }

            public void reward(RuleContext kcontext) {
                throw new UnsupportedOperationException();
            }

            public SimpleScore extractScore(int initScore) {
                return SimpleScore.of((int)0);
            }

            public void configureConstraintWeight(Rule rule, SimpleScore constraintWeight) {
                throw new UnsupportedOperationException();
            }

            public void impactScore(RuleContext kcontext, int weightMultiplier) {
                throw new UnsupportedOperationException();
            }

            public void impactScore(RuleContext kcontext, long weightMultiplier) {
                throw new UnsupportedOperationException();
            }

            public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

