/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.drl.holder;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.constraint.drl.holder.AbstractScoreHolder;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScoreHolder;

public final class HardMediumSoftBigDecimalScoreHolderImpl
extends AbstractScoreHolder<HardMediumSoftBigDecimalScore>
implements HardMediumSoftBigDecimalScoreHolder {
    protected final Map<Rule, AbstractScoreHolder.BigDecimalMatchExecutor> matchExecutorByNumberMap = new LinkedHashMap<Rule, AbstractScoreHolder.BigDecimalMatchExecutor>();
    protected final Map<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftBigDecimalScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftBigDecimalScore>>();
    protected BigDecimal hardScore = BigDecimal.ZERO;
    protected BigDecimal mediumScore = BigDecimal.ZERO;
    protected BigDecimal softScore = BigDecimal.ZERO;

    public HardMediumSoftBigDecimalScoreHolderImpl(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimal getHardScore() {
        return this.hardScore;
    }

    public BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardMediumSoftBigDecimalScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = constraintWeight.isZero() ? (kcontext, matchWeight) -> {} : (constraintWeight.mediumScore().equals(BigDecimal.ZERO) && constraintWeight.softScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addHardConstraintMatch(kcontext, constraintWeight.hardScore().multiply(matchWeight)) : (constraintWeight.hardScore().equals(BigDecimal.ZERO) && constraintWeight.softScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addMediumConstraintMatch(kcontext, constraintWeight.mediumScore().multiply(matchWeight)) : (constraintWeight.hardScore().equals(BigDecimal.ZERO) && constraintWeight.mediumScore().equals(BigDecimal.ZERO) ? (kcontext, matchWeight) -> this.addSoftConstraintMatch(kcontext, constraintWeight.softScore().multiply(matchWeight)) : (kcontext, matchWeight) -> this.addMultiConstraintMatch(kcontext, constraintWeight.hardScore().multiply(matchWeight), constraintWeight.mediumScore().multiply(matchWeight), constraintWeight.softScore().multiply(matchWeight)))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch(kcontext, constraintWeight.hardScore().multiply(weightMultiplier.hardScore()), constraintWeight.mediumScore().multiply(weightMultiplier.mediumScore()), constraintWeight.softScore().multiply(weightMultiplier.softScore())));
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier.negate(), mediumWeightMultiplier.negate(), softWeightMultiplier.negate());
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, BigDecimal.ONE);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier));
    }

    @Override
    public void impactScore(RuleContext kcontext, long weightMultiplier) {
        this.impactScore(kcontext, BigDecimal.valueOf(weightMultiplier));
    }

    @Override
    public void impactScore(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.BigDecimalMatchExecutor matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    private void impactScore(RuleContext kcontext, BigDecimal hardWeightMultiplier, BigDecimal mediumWeightMultiplier, BigDecimal softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        AbstractScoreHolder.ScoreMatchExecutor<HardMediumSoftBigDecimalScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardMediumSoftBigDecimalScore.of((BigDecimal)hardWeightMultiplier, (BigDecimal)mediumWeightMultiplier, (BigDecimal)softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, BigDecimal hardWeight) {
        this.hardScore = this.hardScore.add(hardWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
        }, () -> HardMediumSoftBigDecimalScore.ofHard((BigDecimal)hardWeight));
    }

    public void addMediumConstraintMatch(RuleContext kcontext, BigDecimal mediumWeight) {
        this.mediumScore = this.mediumScore.add(mediumWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
        }, () -> HardMediumSoftBigDecimalScore.ofMedium((BigDecimal)mediumWeight));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, BigDecimal softWeight) {
        this.softScore = this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.ofSoft((BigDecimal)softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, BigDecimal hardWeight, BigDecimal mediumWeight, BigDecimal softWeight) {
        this.hardScore = this.hardScore.add(hardWeight);
        this.mediumScore = this.mediumScore.add(mediumWeight);
        this.softScore = this.softScore.add(softWeight);
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore = this.hardScore.subtract(hardWeight);
            this.mediumScore = this.mediumScore.subtract(mediumWeight);
            this.softScore = this.softScore.subtract(softWeight);
        }, () -> HardMediumSoftBigDecimalScore.of((BigDecimal)hardWeight, (BigDecimal)mediumWeight, (BigDecimal)softWeight));
    }

    @Override
    public HardMediumSoftBigDecimalScore extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.ofUninitialized((int)initScore, (BigDecimal)this.hardScore, (BigDecimal)this.mediumScore, (BigDecimal)this.softScore);
    }
}

