/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.AbstractIndexerTest;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.ManyIndexProperties;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.common.bi.DefaultBiJoiner;
import org.optaplanner.core.api.score.stream.Joiners;

class EqualsIndexerTest
extends AbstractIndexerTest {
    private final DefaultBiJoiner<AbstractIndexerTest.Person, AbstractIndexerTest.Person> joiner = (DefaultBiJoiner)Joiners.equal(p -> p.gender).and(Joiners.equal(p -> p.age));

    EqualsIndexerTest() {
    }

    @Test
    void getEmpty() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        Assertions.assertThat(this.getTupleMap(indexer, "F", 40)).isEmpty();
    }

    @Test
    void putTwice() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        UniTuple<String> annTuple = EqualsIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple, (Object)"Ann value");
        Assertions.assertThatThrownBy(() -> indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), (Tuple)annTuple, (Object)"Ann value")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void removeTwice() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        UniTuple<String> annTuple = EqualsIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple, (Object)"Ann value");
        UniTuple<String> ednaTuple = EqualsIndexerTest.newTuple("Edna-F-40");
        Assertions.assertThatThrownBy(() -> indexer.remove((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), (Tuple)ednaTuple)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThat((String)((String)indexer.remove((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple))).isEqualTo("Ann value");
        Assertions.assertThatThrownBy(() -> indexer.remove((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), (Tuple)annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void visit() {
        Indexer indexer = new IndexerFactory(this.joiner).buildIndexer(true);
        UniTuple<String> annTuple = EqualsIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), annTuple, (Object)"Ann value");
        UniTuple<String> bethTuple = EqualsIndexerTest.newTuple("Beth-F-30");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 30}), bethTuple, (Object)"Beth value");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"M", 40}), EqualsIndexerTest.newTuple("Carl-M-40"), (Object)"Carl value");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"M", 30}), EqualsIndexerTest.newTuple("Dan-M-30"), (Object)"Dan value");
        UniTuple<String> ednaTuple = EqualsIndexerTest.newTuple("Edna-F-40");
        indexer.put((IndexProperties)new ManyIndexProperties(new Object[]{"F", 40}), ednaTuple, (Object)"Edna value");
        Assertions.assertThat(this.getTupleMap(indexer, "F", 40)).containsOnlyKeys((Object[])new UniTuple[]{annTuple, ednaTuple});
        Assertions.assertThat(this.getTupleMap(indexer, "F", 30)).containsOnlyKeys((Object[])new UniTuple[]{bethTuple});
        Assertions.assertThat(this.getTupleMap(indexer, "F", 20)).isEmpty();
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTuple((Object)factA, 0);
    }
}

