/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.collection.TupleListEntry;
import org.optaplanner.constraint.streams.bavet.common.index.AbstractIndexerTest;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.constraint.streams.bavet.uni.UniTupleImpl;

class NoneIndexerTest
extends AbstractIndexerTest {
    NoneIndexerTest() {
    }

    @Test
    void isEmpty() {
        NoneIndexer indexer = new NoneIndexer();
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$isEmpty$0((Indexer)indexer, arg_0));
    }

    @Test
    void put() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        Assertions.assertThat((int)indexer.size((IndexProperties)NoneIndexProperties.INSTANCE)).isEqualTo(0);
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple);
        Assertions.assertThat((int)indexer.size((IndexProperties)NoneIndexProperties.INSTANCE)).isEqualTo(1);
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$put$1((Indexer)indexer, annTuple, arg_0));
    }

    @Test
    void removeTwice() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        TupleListEntry annEntry = indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple);
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$removeTwice$2((Indexer)indexer, annTuple, arg_0));
        indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, annEntry);
        SoftAssertions.assertSoftly(arg_0 -> this.lambda$removeTwice$3((Indexer)indexer, arg_0));
        Assertions.assertThatThrownBy(() -> NoneIndexerTest.lambda$removeTwice$4((Indexer)indexer, annEntry)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void visit() {
        NoneIndexer indexer = new NoneIndexer();
        UniTuple<String> annTuple = NoneIndexerTest.newTuple("Ann-F-40");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, annTuple);
        UniTuple<String> bethTuple = NoneIndexerTest.newTuple("Beth-F-30");
        indexer.put((IndexProperties)NoneIndexProperties.INSTANCE, bethTuple);
        Assertions.assertThat(this.getTuples(indexer, new Object[0])).containsOnly((Object[])new UniTuple[]{annTuple, bethTuple});
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTupleImpl((Object)factA, 0);
    }

    private static /* synthetic */ void lambda$removeTwice$4(Indexer indexer, TupleListEntry annEntry) throws Throwable {
        indexer.remove((IndexProperties)NoneIndexProperties.INSTANCE, annEntry);
    }

    private /* synthetic */ void lambda$removeTwice$3(Indexer indexer, SoftAssertions softly) {
        softly.assertThat(indexer.isEmpty()).isTrue();
        softly.assertThat(this.getTuples(indexer, new Object[0])).isEmpty();
    }

    private /* synthetic */ void lambda$removeTwice$2(Indexer indexer, UniTuple annTuple, SoftAssertions softly) {
        softly.assertThat(indexer.isEmpty()).isFalse();
        softly.assertThat(this.getTuples(indexer, new Object[0])).containsExactly((Object[])new UniTuple[]{annTuple});
    }

    private /* synthetic */ void lambda$put$1(Indexer indexer, UniTuple annTuple, SoftAssertions softly) {
        softly.assertThat(indexer.isEmpty()).isFalse();
        softly.assertThat(this.getTuples(indexer, new Object[0])).containsExactly((Object[])new UniTuple[]{annTuple});
    }

    private /* synthetic */ void lambda$isEmpty$0(Indexer indexer, SoftAssertions softly) {
        softly.assertThat(this.getTuples(indexer, new Object[0])).isEmpty();
        softly.assertThat(indexer.isEmpty()).isTrue();
    }
}

