/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.testdata.domain.chained.shadow.TestdataShadowingChainedAnchor;
import org.optaplanner.core.impl.testdata.domain.chained.shadow.TestdataShadowingChainedEntity;
import org.optaplanner.core.impl.testdata.domain.chained.shadow.TestdataShadowingChainedSolution;

public abstract class AbstractFactChangePropagationTest {
    private static final String VALUE_CODE = "v1";
    private final Solver<TestdataShadowingChainedSolution> solver;

    protected AbstractFactChangePropagationTest(ConstraintStreamImplType constraintStreamImplType) {
        this.solver = this.buildSolver(constraintStreamImplType);
    }

    @Test
    void delayedFactChangePropagation() {
        TestdataShadowingChainedEntity entity = new TestdataShadowingChainedEntity("e1");
        TestdataShadowingChainedAnchor value = new TestdataShadowingChainedAnchor(VALUE_CODE);
        TestdataShadowingChainedSolution inputProblem = new TestdataShadowingChainedSolution();
        inputProblem.setChainedAnchorList(Arrays.asList(value));
        inputProblem.setChainedEntityList(Arrays.asList(entity));
        TestdataShadowingChainedSolution solution = (TestdataShadowingChainedSolution)this.solver.solve((Object)inputProblem);
        TestdataShadowingChainedEntity solvedEntity = (TestdataShadowingChainedEntity)solution.getChainedEntityList().get(0);
        Assertions.assertThat((Object)solvedEntity.getChainedObject()).isNotNull();
        Assertions.assertThat((String)solvedEntity.getAnchor().getCode()).isEqualTo(VALUE_CODE);
        Assertions.assertThat((boolean)solution.getScore().isFeasible()).isTrue();
    }

    private Solver<TestdataShadowingChainedSolution> buildSolver(ConstraintStreamImplType constraintStreamImplType) {
        SolverConfig solverConfig = new SolverConfig().withEntityClasses(new Class[]{TestdataShadowingChainedEntity.class}).withSolutionClass(TestdataShadowingChainedSolution.class).withConstraintProviderClass(ChainedEntityConstraintProvider.class).withPhases(new PhaseConfig[]{new ConstructionHeuristicPhaseConfig()});
        solverConfig.getScoreDirectorFactoryConfig().setConstraintStreamImplType(constraintStreamImplType);
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        return solverFactory.buildSolver();
    }

    public static class ChainedEntityConstraintProvider
    implements ConstraintProvider {
        public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
            return new Constraint[]{this.anchorCannotBeNull(constraintFactory)};
        }

        private Constraint anchorCannotBeNull(ConstraintFactory constraintFactory) {
            return constraintFactory.forEach(TestdataShadowingChainedEntity.class).filter(testdataShadowingChainedEntity -> AbstractFactChangePropagationTest.VALUE_CODE.equals(testdataShadowingChainedEntity.getAnchor().getCode())).penalize("anchorCannotBeNull", (Score)SimpleScore.ONE);
        }
    }
}

