/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.BendableLongScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataBendableLongScoreSolution;

class BendableLongScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataBendableLongScoreSolution, BendableLongScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    BendableLongScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        BendableLongScoreInliner scoreInliner = new BendableLongScoreInliner(true, 1, 2);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactHard() {
        BendableLongScoreInliner scoreInliner = new BendableLongScoreInliner(true, 1, 2);
        BendableLongScore constraintWeight = this.buildScore(90L, 0L, 0L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(90L, 0L, 0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(270L, 0L, 0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(90L, 0L, 0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactSoft1() {
        BendableLongScoreInliner scoreInliner = new BendableLongScoreInliner(true, 1, 2);
        BendableLongScore constraintWeight = this.buildScore(0L, 90L, 0L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 90L, 0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 270L, 0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 90L, 0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactSoft2() {
        BendableLongScoreInliner scoreInliner = new BendableLongScoreInliner(true, 1, 2);
        BendableLongScore constraintWeight = this.buildScore(0L, 0L, 90L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 90L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 270L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 90L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Test
    void impactAll() {
        BendableLongScoreInliner scoreInliner = new BendableLongScoreInliner(true, 1, 2);
        BendableLongScore constraintWeight = this.buildScore(10L, 100L, 1000L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(100L, 1000L, 10000L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(300L, 3000L, 30000L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(100L, 1000L, 10000L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0L, 0L, 0L));
    }

    @Override
    protected SolutionDescriptor<TestdataBendableLongScoreSolution> buildSolutionDescriptor() {
        return TestdataBendableLongScoreSolution.buildSolutionDescriptor();
    }

    private BendableLongScore buildScore(long hard, long soft1, long soft2) {
        return BendableLongScore.of((long[])new long[]{hard}, (long[])new long[]{soft1, soft2});
    }
}

