/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jaxb.impl.domain.solution;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class JaxbSolutionFileIO<Solution_>
implements SolutionFileIO<Solution_> {
    public static final String FILE_EXTENSION = "xml";
    private final Marshaller marshaller;
    private final Unmarshaller unmarshaller;

    public JaxbSolutionFileIO(Class ... jaxbAnnotatedClasses) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])jaxbAnnotatedClasses);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.unmarshaller = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("JAXB creation for classes (" + Arrays.toString(jaxbAnnotatedClasses) + ") has failed.", e);
        }
    }

    public String getInputFileExtension() {
        return FILE_EXTENSION;
    }

    public String getOutputFileExtension() {
        return FILE_EXTENSION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Solution_ read(File inputSolutionFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(inputSolutionFile), "UTF-8");){
            Object object = this.unmarshaller.unmarshal((Reader)reader);
            return (Solution_)object;
        }
        catch (IOException | JAXBException e) {
            throw new IllegalArgumentException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(Solution_ solution, File outputSolutionFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputSolutionFile), "UTF-8");){
            this.marshaller.marshal(solution, (Writer)writer);
        }
        catch (IOException | JAXBException e) {
            throw new IllegalArgumentException("Failed writing outputSolutionFile (" + outputSolutionFile + ").", e);
        }
    }
}

