/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.jaxb.impl.domain.solution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.testdata.util.CodeAssertable;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;
import org.optaplanner.persistence.jaxb.impl.domain.solution.JaxbSolutionFileIO;
import org.optaplanner.persistence.jaxb.impl.testdata.domain.JaxbTestdataEntity;
import org.optaplanner.persistence.jaxb.impl.testdata.domain.JaxbTestdataSolution;
import org.optaplanner.persistence.jaxb.impl.testdata.domain.JaxbTestdataValue;

public class JaxbSolutionFileIOTest {
    private static File solutionTestDir;

    @BeforeAll
    public static void setup() throws IOException {
        solutionTestDir = new File("target/solutionTest/");
        solutionTestDir.mkdirs();
    }

    @Test
    public void readAndWrite() {
        JaxbSolutionFileIO solutionFileIO = new JaxbSolutionFileIO(new Class[]{JaxbTestdataSolution.class});
        File file = new File(solutionTestDir, "testdataSolution.xml");
        JaxbTestdataSolution original = new JaxbTestdataSolution("s1");
        JaxbTestdataValue originalV1 = new JaxbTestdataValue("v1");
        original.setValueList(Arrays.asList(originalV1, new JaxbTestdataValue("v2")));
        original.setEntityList(Arrays.asList(new JaxbTestdataEntity("e1"), new JaxbTestdataEntity("e2", originalV1), new JaxbTestdataEntity("e3")));
        original.setScore(SimpleScore.of((int)-123));
        solutionFileIO.write((Object)original, file);
        JaxbTestdataSolution copy = (JaxbTestdataSolution)solutionFileIO.read(file);
        Assert.assertNotSame((Object)original, (Object)copy);
        PlannerAssert.assertCode((String)"s1", (CodeAssertable)copy);
        PlannerAssert.assertAllCodesOfIterator(copy.getValueList().iterator(), (String[])new String[]{"v1", "v2"});
        PlannerAssert.assertAllCodesOfIterator(copy.getEntityList().iterator(), (String[])new String[]{"e1", "e2", "e3"});
        JaxbTestdataValue copyV1 = copy.getValueList().get(0);
        JaxbTestdataEntity copyE2 = copy.getEntityList().get(1);
        PlannerAssert.assertCode((String)"v1", (CodeAssertable)copyE2.getValue());
        Assert.assertSame((Object)copyV1, (Object)copyE2.getValue());
        Assert.assertEquals((Object)SimpleScore.of((int)-123), (Object)copy.getScore());
    }
}

