/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream.impl.domain.solution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.BeforeClass;
import org.junit.Test;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.testdata.util.CodeAssertable;
import org.optaplanner.core.impl.testdata.util.PlannerAssert;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;
import org.optaplanner.persistence.xstream.impl.testdata.domain.XStreamTestdataEntity;
import org.optaplanner.persistence.xstream.impl.testdata.domain.XStreamTestdataSolution;
import org.optaplanner.persistence.xstream.impl.testdata.domain.XStreamTestdataValue;

public class XStreamSolutionFileIOTest {
    private static File solutionTestDir;

    @BeforeClass
    public static void setup() throws IOException {
        solutionTestDir = new File("target/solutionTest/");
        solutionTestDir.mkdirs();
    }

    @Test
    public void readAndWrite() {
        XStreamSolutionFileIO solutionFileIO = new XStreamSolutionFileIO(new Class[]{XStreamTestdataSolution.class});
        File file = new File(solutionTestDir, "testdataSolution.xml");
        XStreamTestdataSolution original = new XStreamTestdataSolution("s1");
        XStreamTestdataValue originalV1 = new XStreamTestdataValue("v1");
        original.setValueList(Arrays.asList(originalV1, new XStreamTestdataValue("v2")));
        original.setEntityList(Arrays.asList(new XStreamTestdataEntity("e1"), new XStreamTestdataEntity("e2", originalV1), new XStreamTestdataEntity("e3")));
        original.setScore(SimpleScore.valueOfInitialized((int)-123));
        solutionFileIO.write((Object)original, file);
        XStreamTestdataSolution copy = (XStreamTestdataSolution)((Object)solutionFileIO.read(file));
        PlannerAssert.assertNotSame((Object)((Object)original), (Object)((Object)copy));
        PlannerAssert.assertCode((String)"s1", (CodeAssertable)copy);
        PlannerAssert.assertAllCodesOfIterator(copy.getValueList().iterator(), (String[])new String[]{"v1", "v2"});
        PlannerAssert.assertAllCodesOfIterator(copy.getEntityList().iterator(), (String[])new String[]{"e1", "e2", "e3"});
        XStreamTestdataValue copyV1 = copy.getValueList().get(0);
        XStreamTestdataEntity copyE2 = copy.getEntityList().get(1);
        PlannerAssert.assertCode((String)"v1", (CodeAssertable)copyE2.getValue());
        PlannerAssert.assertSame((Object)((Object)copyV1), (Object)((Object)copyE2.getValue()));
        PlannerAssert.assertEquals((Object)SimpleScore.valueOfInitialized((int)-123), (Object)copy.getScore());
    }
}

