/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream.api.score;

import com.thoughtworks.xstream.XStream;
import org.assertj.core.api.Assertions;
import org.optaplanner.core.api.score.Score;

public abstract class AbstractScoreXStreamConverterTest {
    protected <Score_ extends Score<Score_>, W extends TestScoreWrapper<Score_>> void assertSerializeAndDeserialize(Score_ expectedScore, W input) {
        XStream xStream = new XStream();
        xStream.setMode(1002);
        xStream.processAnnotations(input.getClass());
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByRegExp(new String[]{"org\\.optaplanner\\.\\w+\\.config\\..*", "org\\.optaplanner\\.persistence\\.xstream\\..*\\$Test\\w+ScoreWrapper"});
        String xmlString = xStream.toXML(input);
        TestScoreWrapper output = (TestScoreWrapper)xStream.fromXML(xmlString);
        Assertions.assertThat(output.getScore()).isEqualTo(expectedScore);
        Object regex = expectedScore != null ? "<([\\w\\-\\.]+)( id=\"\\d+\")?>\\s*<score( id=\"\\d+\")?>" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "</score>\\s*</\\1>" : "<([\\w\\-\\.]+)( id=\"\\d+\")?/>";
        if (!xmlString.matches((String)regex)) {
            Assertions.fail((String)("Regular expression match failed.\nExpected regular expression: " + (String)regex + "\nActual string: " + xmlString));
        }
    }

    public static abstract class TestScoreWrapper<Score_ extends Score<Score_>> {
        public abstract Score_ getScore();
    }
}

