/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.List;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.benchmark.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.benchmark.quarkus.testdata.normal.domain.TestdataQuarkusOtherEntity;
import org.optaplanner.benchmark.quarkus.testdata.normal.domain.TestdataQuarkusSolution;
import org.optaplanner.core.config.solver.SolverConfig;

class OptaPlannerBenchmarkProcessorInheritedSolverBenchmarkTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.benchmark.solver.termination.best-score-limit", "0").setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusOtherEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class})).addAsResource("solverConfig.xml")).addAsResource("solverBenchmarkConfigWithInheritedSolverBenchmark.xml", "solverBenchmarkConfig.xml"));
    @Inject
    SolverConfig solverConfig;
    @Inject
    PlannerBenchmarkConfig plannerBenchmarkConfig;

    OptaPlannerBenchmarkProcessorInheritedSolverBenchmarkTest() {
    }

    @Test
    void inheritClassesFromSolverConfig() {
        Assertions.assertEquals(TestdataQuarkusSolution.class, (Object)this.solverConfig.getSolutionClass());
        Assertions.assertEquals((int)2, (int)this.solverConfig.getEntityClassList().size());
        Assertions.assertTrue((boolean)this.solverConfig.getEntityClassList().contains(TestdataQuarkusEntity.class));
        Assertions.assertTrue((boolean)this.solverConfig.getEntityClassList().contains(TestdataQuarkusOtherEntity.class));
        Assertions.assertEquals((long)5L, (Long)this.plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getTerminationConfig().getMillisecondsSpentLimit());
        Assertions.assertEquals(List.of(TestdataQuarkusEntity.class), (Object)this.plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig().getSolverConfig().getEntityClassList());
        SolverBenchmarkConfig childBenchmarkConfig = (SolverBenchmarkConfig)this.plannerBenchmarkConfig.getSolverBenchmarkConfigList().get(0);
        Assertions.assertEquals(TestdataQuarkusSolution.class, (Object)childBenchmarkConfig.getSolverConfig().getSolutionClass());
        Assertions.assertNull((Object)childBenchmarkConfig.getSolverConfig().getEntityClassList());
        Assertions.assertEquals(TestdataQuarkusConstraintProvider.class, (Object)childBenchmarkConfig.getSolverConfig().getScoreDirectorFactoryConfig().getConstraintProviderClass());
        childBenchmarkConfig = (SolverBenchmarkConfig)this.plannerBenchmarkConfig.getSolverBenchmarkConfigList().get(1);
        Assertions.assertEquals(TestdataQuarkusConstraintProvider.class, (Object)childBenchmarkConfig.getSolverConfig().getSolutionClass());
        Assertions.assertNull((Object)childBenchmarkConfig.getSolverConfig().getEntityClassList());
        Assertions.assertEquals(TestdataQuarkusConstraintProvider.class, (Object)childBenchmarkConfig.getSolverConfig().getScoreDirectorFactoryConfig().getConstraintProviderClass());
    }
}

