/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.deployment.Capabilities;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.quarkus.deployment.OptaPlannerProcessor;

class OptaPlannerProcessorTest {
    OptaPlannerProcessorTest() {
    }

    @Test
    void customScoreDrl_overrides_solverConfig() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"config_constraints.drl"});
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.of("some.drl"));
        Capabilities capabilities = new Capabilities(Collections.singleton("kogito-rules"));
        optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig, capabilities);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"some.drl"});
    }

    @Test
    void defaultScoreDrl_does_not_override_solverConfig() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"config_constraints.drl"});
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.empty());
        Mockito.when((Object)optaPlannerProcessor.defaultConstraintsDrl()).thenReturn(Optional.of("constraints.drl"));
        Capabilities capabilities = new Capabilities(Collections.singleton("kogito-rules"));
        optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig, capabilities);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"config_constraints.drl"});
    }

    @Test
    void defaultScoreDrl_applies_if_solverConfig_does_not_define_scoreDrl() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.empty());
        Mockito.when((Object)optaPlannerProcessor.defaultConstraintsDrl()).thenReturn(Optional.of("constraints.drl"));
        Capabilities capabilities = new Capabilities(Collections.singleton("kogito-rules"));
        optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig, capabilities);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"constraints.drl"});
    }

    @Test
    void error_if_drools_is_used_and_kogito_rules_capability_is_not_present() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.empty());
        Mockito.when((Object)optaPlannerProcessor.defaultConstraintsDrl()).thenReturn(Optional.of("constraints.drl"));
        Capabilities capabilities = new Capabilities(Collections.emptySet());
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig, capabilities)).isInstanceOf(IllegalStateException.class)).hasMessage("Using scoreDRL in Quarkus, but the dependency org.kie.kogito:kogito-quarkus-rules is not on the classpath.\nMaybe add the dependency org.kie.kogito:kogito-quarkus-rules\nMaybe use a " + ConstraintProvider.class.getSimpleName() + " instead of the scoreDRL.");
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"constraints.drl"});
    }

    private OptaPlannerProcessor mockOptaPlannerProcessor() {
        OptaPlannerProcessor optaPlannerProcessor = (OptaPlannerProcessor)Mockito.mock(OptaPlannerProcessor.class);
        ((OptaPlannerProcessor)Mockito.doCallRealMethod().when((Object)optaPlannerProcessor)).applyScoreDirectorFactoryProperties((IndexView)Mockito.any(), (SolverConfig)Mockito.any(), (Capabilities)Mockito.any());
        return optaPlannerProcessor;
    }
}

