/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.rest;

import io.quarkus.test.QuarkusDevModeTest;
import io.restassured.RestAssured;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.quarkus.rest.SolverConfigTestResource;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

public class OptaPlannerProcessorHotReloadTest {
    @RegisterExtension
    static final QuarkusDevModeTest test = new QuarkusDevModeTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class, SolverConfigTestResource.class})).addAsResource("solverConfig.xml"));

    @Test
    public void solverConfigHotReload() {
        String resp = RestAssured.get((String)"/solver-config/seconds-spent-limit", (Object[])new Object[0]).asString();
        Assertions.assertEquals((Object)"secondsSpentLimit=2", (Object)resp);
        test.modifyResourceFile("solverConfig.xml", s -> s.replace("<secondsSpentLimit>2</secondsSpentLimit>", "<secondsSpentLimit>9</secondsSpentLimit>"));
        resp = RestAssured.get((String)"/solver-config/seconds-spent-limit", (Object[])new Object[0]).asString();
        Assertions.assertEquals((Object)"secondsSpentLimit=9", (Object)resp);
    }
}

