/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Arrays;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.domain.entity.PlanningPin;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningEntityProperty;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.solution.ProblemFactProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.quarkus.gizmo.annotations.AbstractQuarkusRecordableAnnotation;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableAnchorShadowVariable;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableAnnotations;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableConstraintConfigurationProvider;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableConstraintWeight;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableCustomShadowVariable;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableInverseRelationShadowVariable;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningEntityCollectionProperty;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningEntityProperty;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningId;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningPin;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningScore;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningVariable;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordablePlanningVariableReference;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableProblemFactCollectionProperty;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableProblemFactProperty;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableValueRangeProvider;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

public class QuarkusRecordableAnnotationsTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class}));
    IndexView indexView;
    static final DotName PLANNING_ENTITY_COLLECTION_PROPERTY = DotName.createSimple((String)PlanningEntityCollectionProperty.class.getName());
    static final DotName PLANNING_ENTITY_PROPERTY = DotName.createSimple((String)PlanningEntityProperty.class.getName());
    static final DotName PLANNING_SCORE = DotName.createSimple((String)PlanningScore.class.getName());
    static final DotName PROBLEM_FACT_COLLECTION_PROPERTY = DotName.createSimple((String)ProblemFactCollectionProperty.class.getName());
    static final DotName PROBLEM_FACT_PROPERTY = DotName.createSimple((String)ProblemFactProperty.class.getName());
    static final DotName CONSTRAINT_CONFIGURATION_PROVIDER = DotName.createSimple((String)ConstraintConfigurationProvider.class.getName());
    static final DotName CONSTRAINT_WEIGHT = DotName.createSimple((String)ConstraintWeight.class.getName());
    static final DotName PLANNING_PIN = DotName.createSimple((String)PlanningPin.class.getName());
    static final DotName PLANNING_ID = DotName.createSimple((String)PlanningId.class.getName());
    static final DotName PLANNING_VARIABLE = DotName.createSimple((String)PlanningVariable.class.getName());
    static final DotName VALUE_RANGE_PROVIDER = DotName.createSimple((String)ValueRangeProvider.class.getName());
    static final DotName PLANNING_VARIABLE_REFERENCE = DotName.createSimple((String)PlanningVariableReference.class.getName());
    static final DotName ANCHOR_SHADOW_VARIABLE = DotName.createSimple((String)AnchorShadowVariable.class.getName());
    static final DotName CUSTOM_SHADOW_VARIABLE = DotName.createSimple((String)CustomShadowVariable.class.getName());
    static final DotName INVERSE_RELATION_SHADOW_VARIABLE = DotName.createSimple((String)InverseRelationShadowVariable.class.getName());
    static final DotName[] GIZMO_MEMBER_ACCESSOR_ANNOTATIONS = new DotName[]{PLANNING_ENTITY_COLLECTION_PROPERTY, PLANNING_ENTITY_PROPERTY, PLANNING_SCORE, PROBLEM_FACT_COLLECTION_PROPERTY, PROBLEM_FACT_PROPERTY, CONSTRAINT_CONFIGURATION_PROVIDER, CONSTRAINT_WEIGHT, PLANNING_PIN, PLANNING_ID, PLANNING_VARIABLE, PLANNING_VARIABLE_REFERENCE, VALUE_RANGE_PROVIDER, ANCHOR_SHADOW_VARIABLE, CUSTOM_SHADOW_VARIABLE, INVERSE_RELATION_SHADOW_VARIABLE};

    private ClassInfo createClassInfo(DotName annotationClass) {
        ClassInfo classInfo = ClassInfo.create((DotName)annotationClass, (DotName)DotName.createSimple((String)"java.lang.Object"), (short)0, (DotName[])new DotName[0], Collections.emptyMap(), (boolean)false);
        try {
            Method[] annotationParameters = Class.forName(annotationClass.toString()).getMethods();
            Class<?> methodInternalClass = Class.forName("org.jboss.jandex.MethodInternal");
            Object methodInternalArray = Array.newInstance(methodInternalClass, annotationParameters.length);
            Constructor<?> methodInternalCreator = methodInternalClass.getDeclaredConstructor(byte[].class, byte[][].class, Type[].class, Type.class, Short.TYPE, Type.class, Type[].class, Type[].class, AnnotationInstance[].class, AnnotationValue.class);
            methodInternalCreator.setAccessible(true);
            for (int i = 0; i < annotationParameters.length; ++i) {
                ((Object[])methodInternalArray)[i] = annotationParameters[i].getDefaultValue() != null ? methodInternalCreator.newInstance(new Object[]{annotationParameters[i].getName().getBytes(StandardCharsets.UTF_8), new byte[0][], new Type[0], null, (short)0, null, new Type[0], new Type[0], new AnnotationInstance[0], this.getAnnotationValue(annotationParameters[i].getName(), annotationParameters[i].getDefaultValue())}) : methodInternalCreator.newInstance(new Object[]{annotationParameters[i].getName().getBytes(StandardCharsets.UTF_8), new byte[0][], new Type[0], null, (short)0, null, new Type[0], new Type[0], new AnnotationInstance[0], null});
            }
            Field methods = ClassInfo.class.getDeclaredField("methods");
            methods.setAccessible(true);
            methods.set(classInfo, methodInternalArray);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return classInfo;
    }

    private void mockGetClassByNameForAnnotation(DotName annotationClass) {
        Mockito.when((Object)this.indexView.getClassByName(annotationClass)).thenReturn((Object)this.createClassInfo(annotationClass));
    }

    @BeforeEach
    public void setup() {
        this.indexView = (IndexView)Mockito.mock(IndexView.class);
        for (DotName annotation : GIZMO_MEMBER_ACCESSOR_ANNOTATIONS) {
            this.mockGetClassByNameForAnnotation(annotation);
        }
    }

    private AnnotationInstance createAnnotationInstance(Annotation annotation) {
        ArrayList<AnnotationValue> annotationValuesList = new ArrayList<AnnotationValue>();
        HashSet<String> ignoredMethods = new HashSet<String>();
        ignoredMethods.add("toString");
        ignoredMethods.add("hashCode");
        ignoredMethods.add("annotationType");
        for (Method method : annotation.annotationType().getMethods()) {
            try {
                Object result;
                if (method.getParameterCount() != 0 || ignoredMethods.contains(method.getName()) || (result = method.invoke((Object)annotation, new Object[0])) == null) continue;
                annotationValuesList.add(this.getAnnotationValue(method.getName(), result));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return AnnotationInstance.create((DotName)DotName.createSimple((String)annotation.annotationType().getName()), null, annotationValuesList);
    }

    private AnnotationValue getAnnotationValue(String name, Object value) {
        if (value instanceof Boolean) {
            return AnnotationValue.createBooleanValue((String)name, (boolean)((Boolean)value));
        }
        if (value instanceof Byte) {
            return AnnotationValue.createByteValue((String)name, (byte)((Byte)value));
        }
        if (value instanceof Character) {
            return AnnotationValue.createCharacterValue((String)name, (char)((Character)value).charValue());
        }
        if (value instanceof Short) {
            return AnnotationValue.createShortValue((String)name, (short)((Short)value));
        }
        if (value instanceof Integer) {
            return AnnotationValue.createIntegerValue((String)name, (int)((Integer)value));
        }
        if (value instanceof Long) {
            return AnnotationValue.createLongValue((String)name, (long)((Long)value));
        }
        if (value instanceof Float) {
            return AnnotationValue.createFloatValue((String)name, (float)((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return AnnotationValue.createDoubleValue((String)name, (double)((Double)value));
        }
        if (value instanceof String) {
            return AnnotationValue.createStringValue((String)name, (String)((String)value));
        }
        if (value instanceof Class) {
            return AnnotationValue.createClassValue((String)name, (Type)Type.create((DotName)DotName.createSimple((String)((Class)value).getName()), (Type.Kind)Type.Kind.CLASS));
        }
        if (value instanceof Enum) {
            return AnnotationValue.createEnumValue((String)name, (DotName)DotName.createSimple((String)value.getClass().getName()), (String)((Enum)value).name());
        }
        if (value instanceof Annotation) {
            return AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)this.createAnnotationInstance((Annotation)value));
        }
        if (Arrays.isArray((Object)value)) {
            AnnotationValue[] out = new AnnotationValue[Arrays.asList((Object)value).size()];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.getAnnotationValue(null, Arrays.asList((Object)value).get(i));
            }
            return AnnotationValue.createArrayValue((String)name, (AnnotationValue[])out);
        }
        throw new IllegalStateException("Unrecongized class: " + value);
    }

    private void assertConvertedAnnotationMatch(AbstractQuarkusRecordableAnnotation wrapper) {
        AnnotationInstance jandexAnnotation = this.createAnnotationInstance((Annotation)wrapper);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getQuarkusRecorderFriendlyAnnotation((AnnotationInstance)jandexAnnotation, (IndexView)this.indexView)).isEqualTo((Object)wrapper);
    }

    @Test
    public void testGetJavaObjectForJandexAnnotationValue() {
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("bool", true), null, (IndexView)this.indexView)).isEqualTo((Object)true);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("byte", (byte)127), null, (IndexView)this.indexView)).isEqualTo((Object)127);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("char", Character.valueOf('\uffff')), null, (IndexView)this.indexView)).isEqualTo((Object)Character.valueOf('\uffff'));
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("short", (short)Short.MAX_VALUE), null, (IndexView)this.indexView)).isEqualTo((Object)Short.MAX_VALUE);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("int", Integer.MAX_VALUE), null, (IndexView)this.indexView)).isEqualTo((Object)Integer.MAX_VALUE);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("long", Long.MAX_VALUE), null, (IndexView)this.indexView)).isEqualTo((Object)Long.MAX_VALUE);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("float", Float.valueOf(Float.MAX_VALUE)), null, (IndexView)this.indexView)).isEqualTo((Object)Float.valueOf(Float.MAX_VALUE));
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("double", Double.MAX_VALUE), null, (IndexView)this.indexView)).isEqualTo((Object)Double.MAX_VALUE);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("string", "String"), null, (IndexView)this.indexView)).isEqualTo((Object)"String");
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("enum", PlanningVariableGraphType.CHAINED), null, (IndexView)this.indexView)).isEqualTo((Object)"CHAINED");
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("class", Integer.class), null, (IndexView)this.indexView)).isEqualTo(Integer.class);
        HashMap annotationValues = new HashMap();
        QuarkusRecordablePlanningEntityCollectionProperty annotation = new QuarkusRecordablePlanningEntityCollectionProperty(annotationValues);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("class", annotation), null, (IndexView)this.indexView)).isEqualTo((Object)annotation);
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("bool array", new boolean[]{true}), null, (IndexView)this.indexView)).isEqualTo((Object)new boolean[]{true});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("byte array", new byte[]{127}), null, (IndexView)this.indexView)).isEqualTo((Object)new byte[]{127});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("char array", new char[]{'\uffff'}), null, (IndexView)this.indexView)).isEqualTo((Object)new char[]{'\uffff'});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("short array", new short[]{Short.MAX_VALUE}), null, (IndexView)this.indexView)).isEqualTo((Object)new short[]{Short.MAX_VALUE});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("int array", new int[]{Integer.MAX_VALUE}), null, (IndexView)this.indexView)).isEqualTo((Object)new int[]{Integer.MAX_VALUE});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("long array", new long[]{Long.MAX_VALUE}), null, (IndexView)this.indexView)).isEqualTo((Object)new long[]{Long.MAX_VALUE});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("float array", new float[]{Float.MAX_VALUE}), null, (IndexView)this.indexView)).isEqualTo((Object)new float[]{Float.MAX_VALUE});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("double array", new double[]{Double.MAX_VALUE}), null, (IndexView)this.indexView)).isEqualTo((Object)new double[]{Double.MAX_VALUE});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("string array", new String[]{"String"}), null, (IndexView)this.indexView)).isEqualTo((Object)new String[]{"String"});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("enum array", new PlanningVariableGraphType[]{PlanningVariableGraphType.CHAINED}), null, (IndexView)this.indexView)).isEqualTo((Object)new String[]{"CHAINED"});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("class array", new Class[]{Integer.class}), null, (IndexView)this.indexView)).isEqualTo((Object)new Class[]{Integer.class});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("annotation array", new Annotation[]{annotation}), null, (IndexView)this.indexView)).isEqualTo((Object)new Annotation[]{annotation});
        Assertions.assertThat((Object)QuarkusRecordableAnnotations.getJavaObjectForJandexAnnotationValue((AnnotationValue)this.getAnnotationValue("unknown array", new Object[0]), null, (IndexView)this.indexView)).isEqualTo((Object)new Object[0]);
    }

    @Test
    public void testPlanningEntityCollectionWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordablePlanningEntityCollectionProperty annotation = new QuarkusRecordablePlanningEntityCollectionProperty(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testPlanningEntityPropertyWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordablePlanningEntityProperty annotation = new QuarkusRecordablePlanningEntityProperty(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testPlanningScoreWrapper() {
        HashMap<String, Object> annotationValues = new HashMap<String, Object>();
        annotationValues.put("bendableSoftLevelsSize", 1);
        annotationValues.put("bendableHardLevelsSize", 2);
        annotationValues.put("scoreDefinitionClass", ScoreDefinition.class);
        QuarkusRecordablePlanningScore annotation = new QuarkusRecordablePlanningScore(annotationValues);
        Assertions.assertThat((int)annotation.bendableSoftLevelsSize()).isEqualTo(1);
        Assertions.assertThat((int)annotation.bendableHardLevelsSize()).isEqualTo(2);
        Assertions.assertThat((Class)annotation.scoreDefinitionClass()).isEqualTo(ScoreDefinition.class);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testProblemFactCollectionPropertyWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordableProblemFactCollectionProperty annotation = new QuarkusRecordableProblemFactCollectionProperty(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testProblemFactPropertyWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordableProblemFactProperty annotation = new QuarkusRecordableProblemFactProperty(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testConstraintConfigurationProviderWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordableConstraintConfigurationProvider annotation = new QuarkusRecordableConstraintConfigurationProvider(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testConstraintWeightWrapper() {
        HashMap<String, String> annotationValues = new HashMap<String, String>();
        annotationValues.put("constraintPackage", "org.optaplanner.constraints");
        QuarkusRecordableConstraintWeight annotation = new QuarkusRecordableConstraintWeight(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testPlanningPinWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordablePlanningPin annotation = new QuarkusRecordablePlanningPin(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testPlanningIdWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordablePlanningId annotation = new QuarkusRecordablePlanningId(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testPlanningVariableWrapper() {
        HashMap<String, Object> annotationValues = new HashMap<String, Object>();
        annotationValues.put("nullable", false);
        annotationValues.put("graphType", PlanningVariableGraphType.NONE.name());
        annotationValues.put("strengthComparatorClass", PlanningVariable.NullStrengthComparator.class);
        annotationValues.put("strengthWeightFactoryClass", PlanningVariable.NullStrengthWeightFactory.class);
        annotationValues.put("valueRangeProviderRefs", new String[]{"valueRangeProvider"});
        QuarkusRecordablePlanningVariable annotation = new QuarkusRecordablePlanningVariable(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testValueRangeProviderWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordableValueRangeProvider annotation = new QuarkusRecordableValueRangeProvider(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testPlanningVariableReferenceWrapper() {
        HashMap<String, Class<TestdataQuarkusEntity>> annotationValues = new HashMap<String, Class<TestdataQuarkusEntity>>();
        annotationValues.put("entityClass", TestdataQuarkusEntity.class);
        QuarkusRecordablePlanningVariableReference annotation = new QuarkusRecordablePlanningVariableReference(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testAnchorShadowVariableWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordableAnchorShadowVariable annotation = new QuarkusRecordableAnchorShadowVariable(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    @Disabled(value="Classloader issues with creating PlanningVariableReference array")
    public void testCustomShadowVariableWrapper() {
        HashMap<String, Object> annotationValues = new HashMap<String, Object>();
        annotationValues.put("sources", new PlanningVariableReference[0]);
        annotationValues.put("variableListenerClass", CustomShadowVariable.NullVariableListener.class);
        annotationValues.put("variableListenerRef", new PlanningVariableReference[0]);
        QuarkusRecordableCustomShadowVariable annotation = new QuarkusRecordableCustomShadowVariable(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }

    @Test
    public void testInverseRelationShadowVariableWrapper() {
        HashMap annotationValues = new HashMap();
        QuarkusRecordableInverseRelationShadowVariable annotation = new QuarkusRecordableInverseRelationShadowVariable(annotationValues);
        this.assertConvertedAnnotationMatch((AbstractQuarkusRecordableAnnotation)annotation);
    }
}

