/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableAnnotations;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableArrayType;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableParameterizedType;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableTypeVariable;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableTypes;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableWildcardType;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

public class QuarkusRecordableTypesTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class}));
    IndexView indexView;

    @BeforeEach
    public void setup() {
        this.indexView = (IndexView)Mockito.mock(IndexView.class);
    }

    @Test
    public void testPrimitiveTypeWrappers() {
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.BOOLEAN, (IndexView)this.indexView)).isEqualTo(Boolean.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.BYTE, (IndexView)this.indexView)).isEqualTo(Byte.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.CHAR, (IndexView)this.indexView)).isEqualTo(Character.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.SHORT, (IndexView)this.indexView)).isEqualTo(Short.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.INT, (IndexView)this.indexView)).isEqualTo(Integer.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.LONG, (IndexView)this.indexView)).isEqualTo(Long.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.FLOAT, (IndexView)this.indexView)).isEqualTo(Float.TYPE);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)PrimitiveType.DOUBLE, (IndexView)this.indexView)).isEqualTo(Double.TYPE);
    }

    @Test
    public void testArrayTypeWrappers() {
        QuarkusRecordableArrayType expected = new QuarkusRecordableArrayType();
        expected.setGenericComponentType(Integer.class);
        ArrayType arrayType = ArrayType.create((org.jboss.jandex.Type)org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)Integer.class.getName()), (Type.Kind)Type.Kind.CLASS), (int)1);
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)arrayType, (IndexView)this.indexView)).isEqualTo((Object)expected);
    }

    @Test
    public void testVoidTypeWrapper() {
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)"java.lang.void"), (Type.Kind)Type.Kind.VOID), (IndexView)this.indexView)).isEqualTo(Void.TYPE);
    }

    @Test
    @Disabled(value="No way to create jandex TypeVariable, and cannot inject IndexView to fetch an existing one")
    public void testTypeVariableWrapper() {
        Type[] bounds = new Type[]{Supplier.class};
        QuarkusRecordableTypeVariable expected = new QuarkusRecordableTypeVariable();
        AnnotationInstance annotationInstance = AnnotationInstance.create((DotName)DotName.createSimple((String)PlanningScore.class.getName()), null, Collections.emptyList());
        expected.setName("MyTypeVariable");
        expected.setBounds(bounds);
        expected.setAnnotationList(Collections.singletonList(QuarkusRecordableAnnotations.getQuarkusRecorderFriendlyAnnotation((AnnotationInstance)annotationInstance, (IndexView)this.indexView)));
    }

    @Test
    public void testWildcardTypeWrapper() {
        QuarkusRecordableWildcardType expected = new QuarkusRecordableWildcardType();
        expected.setLowerBounds(new Type[0]);
        expected.setUpperBounds(new Type[]{String.class});
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)WildcardType.create((org.jboss.jandex.Type)org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)"java.lang.String"), (Type.Kind)Type.Kind.CLASS), (boolean)true), (IndexView)this.indexView)).isEqualTo((Object)expected);
        expected = new QuarkusRecordableWildcardType();
        expected.setLowerBounds(new Type[]{String.class});
        expected.setUpperBounds(new Type[]{Object.class});
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)WildcardType.create((org.jboss.jandex.Type)org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)"java.lang.String"), (Type.Kind)Type.Kind.CLASS), (boolean)false), (IndexView)this.indexView)).isEqualTo((Object)expected);
    }

    @Test
    public void testParameterizedTypeWrapper() {
        QuarkusRecordableParameterizedType expected = new QuarkusRecordableParameterizedType();
        expected.setOwnerType(String.class);
        expected.setRawTypeName("java.util.Collection");
        expected.setActualTypeArguments(new Type[]{String.class});
        Assertions.assertThat((Object)QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)ParameterizedType.create((DotName)DotName.createSimple((String)"java.util.Collection"), (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)"java.lang.String"), (Type.Kind)Type.Kind.CLASS)}, (org.jboss.jandex.Type)org.jboss.jandex.Type.create((DotName)DotName.createSimple((String)"java.lang.String"), (Type.Kind)Type.Kind.CLASS)), (IndexView)this.indexView)).isEqualTo((Object)expected);
    }
}

