/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.quarkus.deployment.OptaPlannerProcessor;

class OptaPlannerProcessorTest {
    OptaPlannerProcessorTest() {
    }

    @Test
    void customScoreDrl_overrides_solverConfig() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"config_constraints.drl"});
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.of("some.drl"));
        optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"some.drl"});
    }

    @Test
    void defaultScoreDrl_does_not_override_solverConfig() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig().withScoreDrls(new String[]{"config_constraints.drl"});
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.empty());
        Mockito.when((Object)optaPlannerProcessor.defaultConstraintsDrl()).thenReturn(Optional.of("constraints.drl"));
        optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"config_constraints.drl"});
    }

    @Test
    void defaultScoreDrl_applies_if_solverConfig_does_not_define_scoreDrl() {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        SolverConfig solverConfig = new SolverConfig().withScoreDirectorFactory(scoreDirectorFactoryConfig);
        OptaPlannerProcessor optaPlannerProcessor = this.mockOptaPlannerProcessor();
        Mockito.when((Object)optaPlannerProcessor.constraintsDrl()).thenReturn(Optional.empty());
        Mockito.when((Object)optaPlannerProcessor.defaultConstraintsDrl()).thenReturn(Optional.of("constraints.drl"));
        optaPlannerProcessor.applyScoreDirectorFactoryProperties((IndexView)Mockito.mock(IndexView.class), solverConfig);
        Assertions.assertThat((List)scoreDirectorFactoryConfig.getScoreDrlList()).containsExactly((Object[])new String[]{"constraints.drl"});
    }

    private OptaPlannerProcessor mockOptaPlannerProcessor() {
        OptaPlannerProcessor optaPlannerProcessor = (OptaPlannerProcessor)Mockito.mock(OptaPlannerProcessor.class);
        ((OptaPlannerProcessor)Mockito.doCallRealMethod().when((Object)optaPlannerProcessor)).applyScoreDirectorFactoryProperties((IndexView)Mockito.any(), (SolverConfig)Mockito.any());
        return optaPlannerProcessor;
    }
}

