/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.quarkus.OptaPlannerBeanProvider;
import org.optaplanner.quarkus.OptaPlannerRecorder;
import org.optaplanner.quarkus.deployment.DotNames;
import org.optaplanner.quarkus.deployment.GizmoMemberAccessorEntityEnhancer;
import org.optaplanner.quarkus.deployment.OptaPlannerBuildTimeConfig;

class OptaPlannerProcessor {
    private static final Logger log = Logger.getLogger((String)OptaPlannerProcessor.class.getName());
    OptaPlannerBuildTimeConfig optaPlannerBuildTimeConfig;

    OptaPlannerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("optaplanner");
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchSolverConfigXml() {
        String solverConfigXML = this.optaPlannerBuildTimeConfig.solverConfigXml.orElse("solverConfig.xml");
        return new HotDeploymentWatchedFileBuildItem(solverConfigXML);
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchConstraintsDrl() {
        String constraintsDrl = this.optaPlannerBuildTimeConfig.scoreDrl.orElse("constraints.drl");
        return new HotDeploymentWatchedFileBuildItem(constraintsDrl);
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencyBuildItem() {
        return new IndexDependencyBuildItem("org.optaplanner", "optaplanner-core");
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordAndRegisterBeans(OptaPlannerRecorder recorder, RecorderContext recorderContext, CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        SolverConfig solverConfig;
        IndexView indexView = combinedIndex.getIndex();
        if (indexView.getAnnotations(DotNames.PLANNING_SOLUTION).isEmpty() && indexView.getAnnotations(DotNames.PLANNING_ENTITY).isEmpty()) {
            log.warn((Object)("Skipping OptaPlanner extension because there are no " + PlanningSolution.class.getSimpleName() + " or " + PlanningEntity.class.getSimpleName() + " annotated classes."));
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.optaPlannerBuildTimeConfig.solverConfigXml.isPresent()) {
            String solverConfigXML = this.optaPlannerBuildTimeConfig.solverConfigXml.get();
            if (classLoader.getResource(solverConfigXML) == null) {
                throw new ConfigurationException("Invalid quarkus.optaplanner.solverConfigXML property (" + solverConfigXML + "): that classpath resource does not exist.");
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverConfigXML);
        } else {
            solverConfig = classLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml") : new SolverConfig();
        }
        this.applySolverProperties(recorderContext, indexView, solverConfig);
        this.assertNoMemberAnnotationWithoutClassAnnotation(indexView);
        if (solverConfig.getSolutionClass() != null) {
            Type jandexType = Type.create((DotName)DotName.createSimple((String)solverConfig.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(jandexType).ignoreTypePredicate(dotName -> ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName) || dotName.toString().startsWith("org.optaplanner.api") || dotName.toString().startsWith("org.optaplanner.config") || dotName.toString().startsWith("org.optaplanner.impl")).build());
        }
        LinkedHashSet reflectiveClassSet = new LinkedHashSet();
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
        if (scoreDirectorFactoryConfig != null) {
            if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() != null) {
                reflectiveClassSet.add(scoreDirectorFactoryConfig.getEasyScoreCalculatorClass());
            }
            if (scoreDirectorFactoryConfig.getConstraintProviderClass() != null) {
                reflectiveClassSet.add(scoreDirectorFactoryConfig.getConstraintProviderClass());
            }
            if (scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() != null) {
                reflectiveClassSet.add(scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass());
            }
        }
        this.registerClassesFromAnnotations(indexView, reflectiveClassSet);
        this.generateConstraintVerifier(solverConfig, syntheticBeanBuildItemBuildProducer);
        this.generateDomainAccessors(solverConfig, indexView, generatedBeans, generatedClasses, transformers, reflectiveClassSet);
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        this.optaPlannerBuildTimeConfig.solverManager.parallelSolverCount.ifPresent(arg_0 -> ((SolverManagerConfig)solverManagerConfig).setParallelSolverCount(arg_0));
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverConfigSupplier(solverConfig)).done());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManagerConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverManagerConfig(solverManagerConfig)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{OptaPlannerBeanProvider.class}));
    }

    private void generateConstraintVerifier(SolverConfig solverConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null && this.isClassDefined(DotNames.CONSTRAINT_VERIFIER.toString())) {
            Class constraintProviderClass = solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass();
            Class planningSolutionClass = solverConfig.getSolutionClass();
            List planningEntityClasses = solverConfig.getEntityClassList();
            ConstraintStreamImplType constraintStreamImplType = (ConstraintStreamImplType)ObjectUtils.defaultIfNull((Object)solverConfig.getScoreDirectorFactoryConfig().getConstraintStreamImplType(), (Object)ConstraintStreamImplType.DROOLS);
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotNames.CONSTRAINT_VERIFIER).scope(Singleton.class)).creator(methodCreator -> {
                ResultHandle constraintProviderResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Class)constraintProviderClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle planningSolutionClassResultHandle = methodCreator.loadClass(planningSolutionClass);
                ResultHandle planningEntityClassesResultHandle = methodCreator.newArray(Class.class, planningEntityClasses.size());
                for (int i = 0; i < planningEntityClasses.size(); ++i) {
                    ResultHandle planningEntityClassResultHandle = methodCreator.loadClass((Class)planningEntityClasses.get(i));
                    methodCreator.writeArrayValue(planningEntityClassesResultHandle, i, planningEntityClassResultHandle);
                }
                ResultHandle solutionDescriptorResultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(SolutionDescriptor.class, (String)"buildSolutionDescriptor", SolutionDescriptor.class, (Class[])new Class[]{Class.class, Class[].class}), new ResultHandle[]{planningSolutionClassResultHandle, planningEntityClassesResultHandle});
                ResultHandle constraintVerifierResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Object)"org.optaplanner.test.impl.score.stream.DefaultConstraintVerifier", (Object[])new Object[]{ConstraintProvider.class, SolutionDescriptor.class}), new ResultHandle[]{constraintProviderResultHandle, solutionDescriptorResultHandle});
                ResultHandle constraintStreamImplTypeResultHandle = methodCreator.load((Enum)constraintStreamImplType);
                constraintVerifierResultHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DotNames.CONSTRAINT_VERIFIER.toString(), (String)"withConstraintStreamImplType", (Object)DotNames.CONSTRAINT_VERIFIER.toString(), (Object[])new Object[]{ConstraintStreamImplType.class}), constraintVerifierResultHandle, new ResultHandle[]{constraintStreamImplTypeResultHandle});
                methodCreator.returnValue(constraintVerifierResultHandle);
            })).addType((Type)ParameterizedType.create((DotName)DotNames.CONSTRAINT_VERIFIER, (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)constraintProviderClass.getName()), (Type.Kind)Type.Kind.CLASS), Type.create((DotName)DotName.createSimple((String)planningSolutionClass.getName()), (Type.Kind)Type.Kind.CLASS)}, null))).defaultBean()).done());
        }
    }

    private void applySolverProperties(RecorderContext recorderContext, IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findSolutionClass(recorderContext, indexView));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(recorderContext, indexView));
        }
        this.applyScoreDirectorFactoryProperties(indexView, solverConfig);
        this.optaPlannerBuildTimeConfig.solver.environmentMode.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnvironmentMode(arg_0));
        this.optaPlannerBuildTimeConfig.solver.daemon.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDaemon(arg_0));
        this.optaPlannerBuildTimeConfig.solver.moveThreadCount.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setMoveThreadCount(arg_0));
        this.optaPlannerBuildTimeConfig.solver.domainAccessType.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDomainAccessType(arg_0));
        if (solverConfig.getDomainAccessType() == null) {
            solverConfig.setDomainAccessType(DomainAccessType.REFLECTION);
        }
        this.applyTerminationProperties(solverConfig);
    }

    private Class<?> findSolutionClass(RecorderContext recorderContext, IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
        if (annotationInstances.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        AnnotationTarget solutionTarget = ((AnnotationInstance)annotationInstances.iterator().next()).target();
        if (solutionTarget.kind() != AnnotationTarget.Kind.CLASS) {
            throw new IllegalStateException("A target (" + solutionTarget + ") with a @" + PlanningSolution.class.getSimpleName() + " must be a class.");
        }
        return this.convertClassInfoToClass(solutionTarget.asClass());
    }

    private List<Class<?>> findEntityClassList(RecorderContext recorderContext, IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_ENTITY);
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        List targetList = annotationInstances.stream().map(AnnotationInstance::target).collect(Collectors.toList());
        if (targetList.stream().anyMatch(target -> target.kind() != AnnotationTarget.Kind.CLASS)) {
            throw new IllegalStateException("All targets (" + targetList + ") with a @" + PlanningEntity.class.getSimpleName() + " must be a class.");
        }
        return targetList.stream().map(target -> this.convertClassInfoToClass(target.asClass())).collect(Collectors.toList());
    }

    private void assertNoMemberAnnotationWithoutClassAnnotation(IndexView indexView) {
        HashSet optaplannerFieldAnnotations = new HashSet();
        for (DotName annotationName : DotNames.PLANNING_ENTITY_FIELD_ANNOTATIONS) {
            optaplannerFieldAnnotations.addAll(indexView.getAnnotations(annotationName));
        }
        for (AnnotationInstance annotationInstance : optaplannerFieldAnnotations) {
            ClassInfo declaringClass;
            String prefix;
            AnnotationTarget annotationTarget = annotationInstance.target();
            switch (annotationTarget.kind()) {
                case FIELD: {
                    prefix = "The field (" + annotationTarget.asField().name() + ") ";
                    declaringClass = annotationTarget.asField().declaringClass();
                    break;
                }
                case METHOD: {
                    prefix = "The method (" + annotationTarget.asMethod().name() + ") ";
                    declaringClass = annotationTarget.asMethod().declaringClass();
                    break;
                }
                default: {
                    throw new IllegalStateException("Member annotation @" + annotationInstance.name().withoutPackagePrefix() + " is on (" + annotationTarget + "), which is an invalid target type (" + annotationTarget.kind() + ") for @" + annotationInstance.name().withoutPackagePrefix() + ".");
                }
            }
            if (declaringClass.annotations().containsKey(DotNames.PLANNING_ENTITY)) continue;
            throw new IllegalStateException(prefix + "with a @" + annotationInstance.name().withoutPackagePrefix() + " annotation is in a class (" + declaringClass.name() + ") that does not have a @" + PlanningEntity.class.getSimpleName() + " annotation.\nMaybe add a @" + PlanningEntity.class.getSimpleName() + " annotation on the class (" + declaringClass.name() + ").");
        }
    }

    private void registerClassesFromAnnotations(IndexView indexView, Set<Class<?>> reflectiveClassSet) {
        for (DotNames.BeanDefiningAnnotations beanDefiningAnnotation : DotNames.BeanDefiningAnnotations.values()) {
            for (AnnotationInstance annotationInstance : indexView.getAnnotations(beanDefiningAnnotation.getAnnotationDotName())) {
                for (String parameterName : beanDefiningAnnotation.getParameterNames()) {
                    AnnotationValue value = annotationInstance.value(parameterName);
                    if (value == null) continue;
                    Type type = value.asClass();
                    try {
                        Class<?> beanClass = Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
                        reflectiveClassSet.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot find bean class (" + type.name() + ") referenced in annotation (" + annotationInstance + ").");
                    }
                }
            }
        }
    }

    protected void applyScoreDirectorFactoryProperties(IndexView indexView, SolverConfig solverConfig) {
        boolean isDroolsDynamicPresent;
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig;
        Optional<String> constraintsDrlFromProperty = this.constraintsDrl();
        Optional<String> defaultConstraintsDrl = this.defaultConstraintsDrl();
        Optional<String> effectiveConstraintsDrl = constraintsDrlFromProperty.map(Optional::of).orElse(defaultConstraintsDrl);
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            scoreDirectorFactoryConfig = this.defaultScoreDirectoryFactoryConfig(indexView, effectiveConstraintsDrl);
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        } else {
            scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
            if (constraintsDrlFromProperty.isPresent()) {
                scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(constraintsDrlFromProperty.get()));
            } else if (scoreDirectorFactoryConfig.getScoreDrlList() == null) {
                defaultConstraintsDrl.ifPresent(resolvedConstraintsDrl -> scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(resolvedConstraintsDrl)));
            }
        }
        if (solverConfig.getScoreDirectorFactoryConfig().getScoreDrlList() != null && !(isDroolsDynamicPresent = this.isClassDefined("org.drools.dynamic.DynamicServiceRegistrySupplier"))) {
            throw new IllegalStateException("Using scoreDRL in Quarkus, but the dependency drools-core-dynamic is not on the classpath.\nMaybe add the dependency org.kie.kogito:drools-core-dynamic and exclude the dependency org.kie.kogito:drools-core-static.\nOr maybe use a " + ConstraintProvider.class.getSimpleName() + " instead of the scoreDRL.");
        }
    }

    private boolean isClassDefined(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected Optional<String> constraintsDrl() {
        if (this.optaPlannerBuildTimeConfig.scoreDrl.isPresent()) {
            String constraintsDrl = this.optaPlannerBuildTimeConfig.scoreDrl.get();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader.getResource(constraintsDrl) == null) {
                throw new IllegalStateException("Invalid quarkus.optaplanner.score-drl property (" + constraintsDrl + "): that classpath resource does not exist.");
            }
        }
        return this.optaPlannerBuildTimeConfig.scoreDrl;
    }

    protected Optional<String> defaultConstraintsDrl() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResource("constraints.drl") != null ? Optional.of("constraints.drl") : Optional.empty();
    }

    private ScoreDirectorFactoryConfig defaultScoreDirectoryFactoryConfig(IndexView indexView, Optional<String> constrainsDrl) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findImplementingClass(DotNames.EASY_SCORE_CALCULATOR, indexView));
        scoreDirectorFactoryConfig.setConstraintProviderClass(this.findImplementingClass(DotNames.CONSTRAINT_PROVIDER, indexView));
        scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findImplementingClass(DotNames.INCREMENTAL_SCORE_CALCULATOR, indexView));
        constrainsDrl.ifPresent(value -> scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(value)));
        if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getConstraintProviderClass() == null && scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getScoreDrlList() == null) {
            throw new IllegalStateException("No classes found that implement " + EasyScoreCalculator.class.getSimpleName() + ", " + ConstraintProvider.class.getSimpleName() + " or " + IncrementalScoreCalculator.class.getSimpleName() + ".\nNeither was a property " + "quarkus.optaplanner.score-drl" + " defined, nor a " + "constraints.drl" + " resource found.\n");
        }
        return scoreDirectorFactoryConfig;
    }

    private <T> Class<? extends T> findImplementingClass(DotName targetDotName, IndexView indexView) {
        Collection classInfos = indexView.getAllKnownImplementors(targetDotName);
        if (classInfos.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertClassInfosToString(classInfos) + ") found that implement the interface " + targetDotName + ".");
        }
        if (classInfos.isEmpty()) {
            return null;
        }
        ClassInfo classInfo = (ClassInfo)classInfos.iterator().next();
        return this.convertClassInfoToClass(classInfo);
    }

    private void applyTerminationProperties(SolverConfig solverConfig) {
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        this.optaPlannerBuildTimeConfig.solver.termination.spentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        this.optaPlannerBuildTimeConfig.solver.termination.unimprovedSpentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        this.optaPlannerBuildTimeConfig.solver.termination.bestScoreLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
    }

    private String convertAnnotationInstancesToString(Collection<AnnotationInstance> annotationInstances) {
        return "[" + annotationInstances.stream().map(instance -> instance.target().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private String convertClassInfosToString(Collection<ClassInfo> classInfos) {
        return "[" + classInfos.stream().map(instance -> instance.name().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private <T> Class<? extends T> convertClassInfoToClass(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + className + ") cannot be created during deployment.", e);
        }
    }

    private void generateDomainAccessors(SolverConfig solverConfig, IndexView indexView, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, Set<Class<?>> reflectiveClassSet) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        ClassOutput debuggableClassOutput = (arg_0, arg_1) -> OptaPlannerProcessor.lambda$generateDomainAccessors$8((ClassOutput)classOutput, arg_0, arg_1);
        HashSet<String> generatedMemberAccessorsClassNameSet = new HashSet<String>();
        HashSet<String> gizmoSolutionClonerClassNameSet = new HashSet<String>();
        if (solverConfig.getDomainAccessType() == DomainAccessType.GIZMO) {
            ArrayList membersToGeneratedAccessorsFor = new ArrayList();
            for (DotName dotName : DotNames.GIZMO_MEMBER_ACCESSOR_ANNOTATIONS) {
                membersToGeneratedAccessorsFor.addAll(indexView.getAnnotations(dotName));
            }
            block9: for (AnnotationInstance annotatedMember : membersToGeneratedAccessorsFor) {
                switch (annotatedMember.target().kind()) {
                    case FIELD: {
                        FieldInfo fieldInfo = annotatedMember.target().asField();
                        ClassInfo classInfo = fieldInfo.declaringClass();
                        if (this.shouldIgnoreMember(classInfo)) continue block9;
                        try {
                            generatedMemberAccessorsClassNameSet.add(GizmoMemberAccessorEntityEnhancer.generateFieldAccessor(annotatedMember, indexView, debuggableClassOutput, classInfo, fieldInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchFieldException e) {
                            throw new IllegalStateException("Fail to generate member accessor for field (" + fieldInfo.name() + ") of class " + classInfo.name().toString() + ".", e);
                        }
                    }
                    case METHOD: {
                        MethodInfo methodInfo = annotatedMember.target().asMethod();
                        ClassInfo classInfo = methodInfo.declaringClass();
                        if (this.shouldIgnoreMember(classInfo)) continue block9;
                        try {
                            generatedMemberAccessorsClassNameSet.add(GizmoMemberAccessorEntityEnhancer.generateMethodAccessor(annotatedMember, indexView, debuggableClassOutput, classInfo, methodInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchMethodException e) {
                            throw new IllegalStateException("Failed to generate member accessor for the method (" + methodInfo.name() + ") of the class (" + classInfo.name() + ").", e);
                        }
                    }
                }
                throw new IllegalStateException("The member (" + annotatedMember + ") is not on a field or method.");
            }
            SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((DomainAccessType)DomainAccessType.REFLECTION, (Class)solverConfig.getSolutionClass(), (List)solverConfig.getEntityClassList());
            gizmoSolutionClonerClassNameSet.add(GizmoMemberAccessorEntityEnhancer.generateSolutionCloner(solutionDescriptor, debuggableClassOutput, indexView, transformers));
        }
        GizmoMemberAccessorEntityEnhancer.generateGizmoInitializer((ClassOutput)beanClassOutput, generatedMemberAccessorsClassNameSet, gizmoSolutionClonerClassNameSet);
        GizmoMemberAccessorEntityEnhancer.generateGizmoBeanFactory((ClassOutput)beanClassOutput, reflectiveClassSet);
    }

    private boolean shouldIgnoreMember(ClassInfo declaringClass) {
        return declaringClass.name().toString().startsWith(SolutionDescriptor.class.getName());
    }

    private static /* synthetic */ void lambda$generateDomainAccessors$8(ClassOutput classOutput, String className, byte[] bytes) {
        String DEBUG_CLASSES_DIR = "target/optaplanner-generated-classes";
        if ("target/optaplanner-generated-classes" != null) {
            Path pathToFile = Paths.get("target/optaplanner-generated-classes", className.replace('.', '/') + ".class");
            try {
                Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
                Files.write(pathToFile, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write generated class to file (" + pathToFile + ").", e);
            }
        }
        classOutput.write(className, bytes);
    }
}

