/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import jakarta.inject.Inject;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.quarkus.testdata.superclass.constraints.DummyConstraintProvider;
import org.optaplanner.quarkus.testdata.superclass.domain.TestdataEntity;
import org.optaplanner.quarkus.testdata.superclass.domain.TestdataSolution;

class OptaPlannerProcessorPlanningIdTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage("org.optaplanner.quarkus.testdata.superclass.domain")).addClasses(new Class[]{DummyConstraintProvider.class}));
    @Inject
    SolverFactory<TestdataSolution> solverFactory;

    OptaPlannerProcessorPlanningIdTest() {
    }

    @Test
    void buildSolver() {
        TestdataSolution problem = new TestdataSolution();
        problem.setValueList(IntStream.range(1, 3).mapToObj(i -> "v" + i).collect(Collectors.toList()));
        problem.setEntityList(IntStream.range(1, 3).mapToObj(i -> new TestdataEntity(i)).collect(Collectors.toList()));
        TestdataSolution solution = (TestdataSolution)this.solverFactory.buildSolver().solve((Object)problem);
        Assertions.assertNotNull((Object)solution);
    }
}

