/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.stream.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.test.api.score.stream.SingleConstraintVerification;
import org.optaplanner.test.impl.score.stream.DefaultSingleConstraintAssertion;
import org.optaplanner.test.impl.score.stream.SessionBasedAssertionBuilder;

public final class DefaultSingleConstraintVerification<Solution_, Score_ extends Score<Score_>>
implements SingleConstraintVerification<Solution_> {
    private final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;
    private final SessionBasedAssertionBuilder<Solution_, Score_> sessionBasedAssertionBuilder;

    protected DefaultSingleConstraintVerification(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.sessionBasedAssertionBuilder = SessionBasedAssertionBuilder.create(scoreDirectorFactory);
    }

    @Override
    public final DefaultSingleConstraintAssertion<Solution_, Score_> given(Object ... facts) {
        return this.sessionBasedAssertionBuilder.singleConstraintGiven(facts);
    }

    @Override
    public final DefaultSingleConstraintAssertion<Solution_, Score_> givenSolution(Solution_ solution) {
        try (InnerScoreDirector scoreDirector = this.scoreDirectorFactory.buildScoreDirector(true, true);){
            scoreDirector.setWorkingSolution(Objects.requireNonNull(solution));
            DefaultSingleConstraintAssertion<Solution_, Score> defaultSingleConstraintAssertion = new DefaultSingleConstraintAssertion<Solution_, Score>(this.scoreDirectorFactory, scoreDirector.calculateScore(), scoreDirector.getConstraintMatchTotalMap(), scoreDirector.getIndictmentMap());
            return defaultSingleConstraintAssertion;
        }
    }
}

