/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.common.AbstractConstraint;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.DefaultScoreExplanation;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.test.api.score.stream.SingleConstraintAssertion;

public final class DefaultSingleConstraintAssertion<Solution_, Score_ extends Score<Score_>>
implements SingleConstraintAssertion {
    private final AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;
    private final Score_ score;
    private final Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection;
    private final Collection<Indictment<Score_>> indictmentCollection;

    DefaultSingleConstraintAssertion(AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory, Score_ score, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.scoreDirectorFactory = Objects.requireNonNull(scoreDirectorFactory);
        this.score = (Score)Objects.requireNonNull(score);
        this.constraintMatchTotalCollection = Objects.requireNonNull(constraintMatchTotalMap).values();
        this.indictmentCollection = Objects.requireNonNull(indictmentMap).values();
    }

    @Override
    public void penalizesBy(int matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(long matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizesBy(BigDecimal matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.PENALTY, matchWeightTotal, message);
    }

    @Override
    public void penalizes(long times, String message) {
        this.assertMatchCount(ScoreImpactType.PENALTY, times, message);
    }

    @Override
    public void penalizes(String message) {
        this.assertMatch(ScoreImpactType.PENALTY, message);
    }

    @Override
    public void rewardsWith(int matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(long matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewardsWith(BigDecimal matchWeightTotal, String message) {
        this.validateMatchWeighTotal(matchWeightTotal);
        this.assertImpact(ScoreImpactType.REWARD, matchWeightTotal, message);
    }

    @Override
    public void rewards(long times, String message) {
        this.assertMatchCount(ScoreImpactType.REWARD, times, message);
    }

    @Override
    public void rewards(String message) {
        this.assertMatch(ScoreImpactType.REWARD, message);
    }

    private void validateMatchWeighTotal(Number matchWeightTotal) {
        if (matchWeightTotal.doubleValue() < 0.0) {
            throw new IllegalArgumentException("The matchWeightTotal (" + matchWeightTotal + ") must be positive.");
        }
    }

    private void assertImpact(ScoreImpactType scoreImpactType, Number matchWeightTotal, String message) {
        Number impact = this.deduceImpact();
        long longImpact = impact.longValue();
        AbstractConstraint constraint = (AbstractConstraint)this.scoreDirectorFactory.getConstraints()[0];
        ScoreImpactType actualScoreImpactType = constraint.getScoreImpactType();
        if (actualScoreImpactType == ScoreImpactType.MIXED) {
            switch (scoreImpactType) {
                case REWARD: {
                    if (matchWeightTotal.longValue() != -longImpact) break;
                    return;
                }
                case PENALTY: {
                    if (matchWeightTotal.longValue() != longImpact) break;
                    return;
                }
            }
        } else if (actualScoreImpactType == scoreImpactType && matchWeightTotal.longValue() == longImpact) {
            return;
        }
        String constraintId = constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, matchWeightTotal, actualScoreImpactType, impact, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private Number deduceImpact() {
        ScoreDefinition scoreDefinition = this.scoreDirectorFactory.getScoreDefinition();
        Score zeroScore = scoreDefinition.getZeroScore();
        Number zero = zeroScore.toLevelNumbers()[0];
        if (this.constraintMatchTotalCollection.isEmpty()) {
            return zero;
        }
        Score totalMatchWeightedScore = this.constraintMatchTotalCollection.stream().map(matchScore -> scoreDefinition.divideBySanitizedDivisor(matchScore.getScore(), matchScore.getConstraintWeight())).reduce(zeroScore, Score::add);
        List matchWeightsFound = Arrays.stream(totalMatchWeightedScore.toLevelNumbers()).distinct().filter(matchWeight -> !Objects.equals(matchWeight, zero)).collect(Collectors.toList());
        if (matchWeightsFound.isEmpty()) {
            return zero;
        }
        if (matchWeightsFound.size() != 1) {
            throw new IllegalStateException("Impossible state: expecting at most one match weight, but got matchWeightsFound (" + matchWeightsFound + ") instead.");
        }
        return (Number)matchWeightsFound.get(0);
    }

    private void assertMatchCount(ScoreImpactType scoreImpactType, long expectedMatchCount, String message) {
        long actualMatchCount = this.determineMatchCount(scoreImpactType);
        if (actualMatchCount == expectedMatchCount) {
            return;
        }
        AbstractConstraint constraint = (AbstractConstraint)this.scoreDirectorFactory.getConstraints()[0];
        String constraintId = constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, expectedMatchCount, actualMatchCount, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private void assertMatch(ScoreImpactType scoreImpactType, String message) {
        if (this.determineMatchCount(scoreImpactType) > 0L) {
            return;
        }
        AbstractConstraint constraint = (AbstractConstraint)this.scoreDirectorFactory.getConstraints()[0];
        String constraintId = constraint.getConstraintId();
        String assertionMessage = this.buildAssertionErrorMessage(scoreImpactType, constraintId, message);
        throw new AssertionError((Object)assertionMessage);
    }

    private long determineMatchCount(ScoreImpactType scoreImpactType) {
        if (this.constraintMatchTotalCollection.isEmpty()) {
            return 0L;
        }
        AbstractConstraint constraint = (AbstractConstraint)this.scoreDirectorFactory.getConstraints()[0];
        ScoreImpactType actualImpactType = constraint.getScoreImpactType();
        if (actualImpactType != scoreImpactType && actualImpactType != ScoreImpactType.MIXED) {
            return 0L;
        }
        Score zeroScore = this.scoreDirectorFactory.getScoreDefinition().getZeroScore();
        return this.constraintMatchTotalCollection.stream().mapToLong(constraintMatchTotal -> {
            if (actualImpactType == ScoreImpactType.MIXED) {
                boolean isImpactNegative;
                boolean isImpactPositive = constraintMatchTotal.getScore().compareTo((Object)zeroScore) > 0;
                boolean bl = isImpactNegative = constraintMatchTotal.getScore().compareTo((Object)zeroScore) < 0;
                if (isImpactPositive && scoreImpactType == ScoreImpactType.PENALTY) {
                    return constraintMatchTotal.getConstraintMatchSet().size();
                }
                if (isImpactNegative && scoreImpactType == ScoreImpactType.REWARD) {
                    return constraintMatchTotal.getConstraintMatchSet().size();
                }
                return 0L;
            }
            return constraintMatchTotal.getConstraintMatchSet().size();
        }).sum();
    }

    private String buildAssertionErrorMessage(ScoreImpactType expectedImpactType, Number expectedImpact, ScoreImpactType actualImpactType, Number actualImpact, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s (%s)%n%18s: %s (%s)%n%n  %s";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(expectedImpactType);
        String actualImpactLabel = "Actual " + this.getImpactTypeLabel(actualImpactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedImpact, expectedImpact.getClass(), actualImpactLabel, actualImpact, actualImpact.getClass(), DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildAssertionErrorMessage(ScoreImpactType impactType, long expectedTimes, long actualTimes, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s: %s time(s)%n%18s: %s time(s)%n%n  %s";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(impactType);
        String actualImpactLabel = "Actual " + this.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, expectedTimes, actualImpactLabel, actualTimes, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String buildAssertionErrorMessage(ScoreImpactType impactType, String constraintId, String message) {
        String expectation = message != null ? message : "Broken expectation.";
        String preformattedMessage = "%s%n%18s: %s%n%18s but there was none.%n%n  %s";
        String expectedImpactLabel = "Expected " + this.getImpactTypeLabel(impactType);
        return String.format(preformattedMessage, expectation, "Constraint", constraintId, expectedImpactLabel, DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalCollection, this.indictmentCollection));
    }

    private String getImpactTypeLabel(ScoreImpactType scoreImpactType) {
        if (scoreImpactType == ScoreImpactType.PENALTY) {
            return "penalty";
        }
        if (scoreImpactType == ScoreImpactType.REWARD) {
            return "reward";
        }
        return "impact";
    }
}

