/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.planningid.TestdataStringPlanningIdEntity;
import org.optaplanner.core.impl.testdata.domain.planningid.TestdataStringPlanningIdSolution;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintProvider;

class SingleConstraintAssertionTest {
    private final ConstraintVerifier<TestdataConstraintProvider, TestdataStringPlanningIdSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new TestdataConstraintProvider(), TestdataStringPlanningIdSolution.class, (Class[])new Class[]{TestdataEntity.class, TestdataStringPlanningIdEntity.class});

    SingleConstraintAssertionTest() {
    }

    @Test
    void penalizesAndDoesNotReward() {
        TestdataSolution solution = TestdataSolution.generateSolution((int)2, (int)3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).penalizes("There should be penalties.")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).rewards("There should be rewards")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }

    @Test
    void rewardsButDoesNotPenalize() {
        TestdataSolution solution = TestdataSolution.generateSolution((int)2, (int)3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).rewards("There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).penalizes("There should be penalties.")).hasMessageContaining("There should be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void impacts() {
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[0]).penalizes(0L, "There should be no penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).penalizes(0L, "There should be no penalties")).hasMessageContaining("There should be no penalties").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).penalizes(1L, "There should be penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).penalizes(2L, "There should only be one penalty")).hasMessageContaining("There should only be one penalty").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).rewards(1L, "There should not be rewards")).hasMessageContaining("There should not be rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[0]).rewards(0L, "There should be no rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).rewards(0L, "There should be no rewards")).hasMessageContaining("There should be no rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).rewards(1L, "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).rewards(2L, "There should only be one reward")).hasMessageContaining("There should only be one reward").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).penalizes(1L, "There should not be penalties")).hasMessageContaining("There should not be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void impactsBy() {
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[0]).penalizesBy(0, "There should no penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).penalizesBy(0, "There should be no penalties")).hasMessageContaining("There should be no penalties").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).penalizesBy(1, "There should be penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).penalizesBy(2, "There should only be one penalty")).hasMessageContaining("There should only be one penalty").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("A", new TestdataValue())}).rewardsWith(1, "There should not be rewards")).hasMessageContaining("There should not be rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[0]).rewardsWith(0, "There should no rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).rewardsWith(0, "There should be no rewards")).hasMessageContaining("There should be no rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).rewardsWith(1, "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).rewardsWith(2, "There should only be one reward")).hasMessageContaining("There should only be one reward").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataEntity("B", new TestdataValue())}).penalizesBy(1, "There should not be penalties")).hasMessageContaining("There should not be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void penalizesByCountAndDoesNotReward() {
        TestdataSolution solution = TestdataSolution.generateSolution((int)2, (int)3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).penalizes(3L, "There should be penalties.")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).rewards(1L, "There should be rewards")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }

    @Test
    void rewardsByCountButDoesNotPenalize() {
        TestdataSolution solution = TestdataSolution.generateSolution((int)2, (int)3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).rewards(3L, "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).penalizes(1L, "There should be penalties.")).hasMessageContaining("There should be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void uniquePairShouldWorkOnStringPlanningId() {
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::differentStringEntityHaveDifferentValues).given(new Object[]{new TestdataStringPlanningIdEntity("A", "1"), new TestdataStringPlanningIdEntity("B", "1")}).penalizes(1L, "There should be penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintProvider::differentStringEntityHaveDifferentValues).given(new Object[]{new TestdataStringPlanningIdEntity("A", "1"), new TestdataStringPlanningIdEntity("B", "1")}).rewards(1L, "There should be rewards")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }
}

