/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream.testdata;

import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierFirstEntity;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierSecondEntity;

public final class TestdataConstraintVerifierConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.penalizeEveryEntity(constraintFactory), this.rewardEveryEntity(constraintFactory), this.impactEveryEntity(constraintFactory), this.differentStringEntityHaveDifferentValues(constraintFactory)};
    }

    public Constraint penalizeEveryEntity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TestdataConstraintVerifierFirstEntity.class).penalize((Score)HardSoftScore.ONE_HARD).asConstraint("Penalize every standard entity");
    }

    public Constraint rewardEveryEntity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TestdataConstraintVerifierFirstEntity.class).reward((Score)HardSoftScore.ofSoft((int)2)).asConstraint("Reward every standard entity");
    }

    public Constraint impactEveryEntity(ConstraintFactory constraintFactory) {
        return constraintFactory.forEach(TestdataConstraintVerifierFirstEntity.class).impact((Score)HardSoftScore.ofHard((int)4), entity -> Objects.equals(entity.getCode(), "A") ? 1 : -1).asConstraint("Impact every standard entity");
    }

    public Constraint differentStringEntityHaveDifferentValues(ConstraintFactory constraintFactory) {
        return constraintFactory.forEachUniquePair(TestdataConstraintVerifierSecondEntity.class, Joiners.equal(TestdataConstraintVerifierSecondEntity::getValue)).penalize((Score)HardSoftScore.ofSoft((int)3)).asConstraint("Different String Entity Have Different Values");
    }
}

