/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream.testdata;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.ProblemFactCollectionProperty;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierFirstEntity;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierSecondEntity;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierSolution;

@PlanningSolution
public final class TestdataConstraintVerifierExtendedSolution
extends TestdataConstraintVerifierSolution {
    private List<String> stringValueList;
    private List<TestdataConstraintVerifierSecondEntity> secondEntityList;

    public static TestdataConstraintVerifierExtendedSolution generateSolution(int valueListSize, int entityListSize) {
        TestdataConstraintVerifierExtendedSolution solution = new TestdataConstraintVerifierExtendedSolution("Generated Solution 0");
        ArrayList<TestdataValue> valueList = new ArrayList<TestdataValue>();
        ArrayList<String> secondValueList = new ArrayList<String>();
        for (int i = 0; i < valueListSize; ++i) {
            TestdataValue value = new TestdataValue("Generated Value " + i);
            valueList.add(value);
            secondValueList.add(value.getCode());
        }
        solution.setValueList(valueList);
        solution.setStringValueList(secondValueList);
        ArrayList<TestdataConstraintVerifierFirstEntity> entityList = new ArrayList<TestdataConstraintVerifierFirstEntity>();
        ArrayList<TestdataConstraintVerifierSecondEntity> secondEntityList = new ArrayList<TestdataConstraintVerifierSecondEntity>();
        for (int i = 0; i < entityListSize; ++i) {
            Object entity;
            Object value;
            if (i % 2 == 0) {
                value = (TestdataValue)valueList.get(i % valueListSize);
                entity = new TestdataConstraintVerifierFirstEntity("Generated Entity " + i, (TestdataValue)value);
                entityList.add((TestdataConstraintVerifierFirstEntity)((Object)entity));
                continue;
            }
            value = (String)secondValueList.get(i / valueListSize);
            entity = new TestdataConstraintVerifierSecondEntity("Generated Entity " + i, (String)value);
            secondEntityList.add((TestdataConstraintVerifierSecondEntity)entity);
        }
        solution.setEntityList(entityList);
        solution.setSecondEntityList(secondEntityList);
        return solution;
    }

    public TestdataConstraintVerifierExtendedSolution(String code) {
        super(code);
    }

    @ValueRangeProvider(id="stringValueRange")
    @ProblemFactCollectionProperty
    public List<String> getStringValueList() {
        return this.stringValueList;
    }

    public void setStringValueList(List<String> stringValueList) {
        this.stringValueList = stringValueList;
    }

    @PlanningEntityCollectionProperty
    public List<TestdataConstraintVerifierSecondEntity> getSecondEntityList() {
        return this.secondEntityList;
    }

    public void setSecondEntityList(List<TestdataConstraintVerifierSecondEntity> secondEntityList) {
        this.secondEntityList = secondEntityList;
    }
}

