/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierConstraintProvider;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierExtendedSolution;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierFirstEntity;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierSecondEntity;
import org.optaplanner.test.api.score.stream.testdata.TestdataConstraintVerifierSolution;

class SingleConstraintAssertionTest {
    private final ConstraintVerifier<TestdataConstraintVerifierConstraintProvider, TestdataConstraintVerifierExtendedSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new TestdataConstraintVerifierConstraintProvider(), TestdataConstraintVerifierExtendedSolution.class, (Class[])new Class[]{TestdataConstraintVerifierFirstEntity.class, TestdataConstraintVerifierSecondEntity.class});

    SingleConstraintAssertionTest() {
    }

    @Test
    void penalizesAndDoesNotReward() {
        TestdataConstraintVerifierSolution solution = TestdataConstraintVerifierSolution.generateSolution(2, 3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).penalizes("There should be penalties.")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).rewards("There should be rewards")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }

    @Test
    void rewardsButDoesNotPenalize() {
        TestdataConstraintVerifierSolution solution = TestdataConstraintVerifierSolution.generateSolution(2, 3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).rewards("There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).penalizes("There should be penalties.")).hasMessageContaining("There should be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void impacts() {
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[0]).penalizes(0L, "There should be no penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).penalizes(0L, "There should be no penalties")).hasMessageContaining("There should be no penalties").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).penalizes(1L, "There should be penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).penalizes(2L, "There should only be one penalty")).hasMessageContaining("There should only be one penalty").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).rewards(1L, "There should not be rewards")).hasMessageContaining("There should not be rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[0]).rewards(0L, "There should be no rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).rewards(0L, "There should be no rewards")).hasMessageContaining("There should be no rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).rewards(1L, "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).rewards(2L, "There should only be one reward")).hasMessageContaining("There should only be one reward").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).penalizes(1L, "There should not be penalties")).hasMessageContaining("There should not be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void impactsBy() {
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[0]).penalizesBy(0, "There should no penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).penalizesBy(0, "There should be no penalties")).hasMessageContaining("There should be no penalties").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).penalizesBy(1, "There should be penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).penalizesBy(2, "There should only be one penalty")).hasMessageContaining("There should only be one penalty").hasMessageContaining("Expected penalty");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("A", new TestdataValue())}).rewardsWith(1, "There should not be rewards")).hasMessageContaining("There should not be rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[0]).rewardsWith(0, "There should no rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).rewardsWith(0, "There should be no rewards")).hasMessageContaining("There should be no rewards").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).rewardsWith(1, "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).rewardsWith(2, "There should only be one reward")).hasMessageContaining("There should only be one reward").hasMessageContaining("Expected reward");
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::impactEveryEntity).given(new Object[]{new TestdataConstraintVerifierFirstEntity("B", new TestdataValue())}).penalizesBy(1, "There should not be penalties")).hasMessageContaining("There should not be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void penalizesByCountAndDoesNotReward() {
        TestdataConstraintVerifierSolution solution = TestdataConstraintVerifierSolution.generateSolution(2, 3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).penalizes(3L, "There should be penalties.")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).rewards(1L, "There should be rewards")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }

    @Test
    void penalizesByBigDecimal() {
        TestdataConstraintVerifierSolution solution = TestdataConstraintVerifierSolution.generateSolution(2, 3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).penalizesBy(BigDecimal.valueOf(3L), "There should be penalties.")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::penalizeEveryEntity).given(solution.getEntityList().toArray()).penalizesBy(new BigDecimal("3.01"), "There should be penalties.")).hasMessageContaining("There should be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void rewardsByCountButDoesNotPenalize() {
        TestdataConstraintVerifierSolution solution = TestdataConstraintVerifierSolution.generateSolution(2, 3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).rewards(3L, "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).penalizes(1L, "There should be penalties.")).hasMessageContaining("There should be penalties").hasMessageContaining("Expected penalty");
    }

    @Test
    void rewardsByBigDecimal() {
        TestdataConstraintVerifierSolution solution = TestdataConstraintVerifierSolution.generateSolution(2, 3);
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).rewardsWith(BigDecimal.valueOf(3L), "There should be rewards")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::rewardEveryEntity).given(solution.getEntityList().toArray()).rewardsWith(new BigDecimal("3.01"), "There should be rewards.")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }

    @Test
    void uniquePairShouldWorkOnStringPlanningId() {
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::differentStringEntityHaveDifferentValues).given(new Object[]{new TestdataConstraintVerifierSecondEntity("A", "1"), new TestdataConstraintVerifierSecondEntity("B", "1")}).penalizes(1L, "There should be penalties")).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.constraintVerifier.verifyThat(TestdataConstraintVerifierConstraintProvider::differentStringEntityHaveDifferentValues).given(new Object[]{new TestdataConstraintVerifierSecondEntity("A", "1"), new TestdataConstraintVerifierSecondEntity("B", "1")}).rewards(1L, "There should be rewards")).hasMessageContaining("There should be rewards").hasMessageContaining("Expected reward");
    }
}

