/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.solver.change;

import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.api.solver.change.ProblemChangeDirector;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntityGroup;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValue;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValueGroup;
import org.optaplanner.test.api.solver.change.MockProblemChangeDirector;

class MockProblemChangeDirectorTest {
    MockProblemChangeDirectorTest() {
    }

    @Test
    void problemChange() {
        TestdataLavishEntityGroup entityGroupOne = new TestdataLavishEntityGroup("entityGroupOne");
        TestdataLavishValueGroup valueGroupOne = new TestdataLavishValueGroup("valueGroupOne");
        TestdataLavishEntity addedEntity = new TestdataLavishEntity("newly added entity", entityGroupOne);
        TestdataLavishEntity removedEntity = new TestdataLavishEntity("entity to remove", entityGroupOne);
        TestdataLavishValue addedFact = new TestdataLavishValue("newly added fact", valueGroupOne);
        TestdataLavishValue removedFact = new TestdataLavishValue("fact to remove", valueGroupOne);
        TestdataLavishEntity changedEntity = new TestdataLavishEntity("changed entity", entityGroupOne);
        TestdataLavishValue changedFact = new TestdataLavishValue("changed entity value", valueGroupOne);
        TestdataLavishEntity removedWorkingEntity = new TestdataLavishEntity("working entity to remove", entityGroupOne);
        TestdataLavishValue removedWorkingFact = new TestdataLavishValue("working fact to remove", valueGroupOne);
        TestdataLavishEntity changedWorkingEntity = new TestdataLavishEntity("working changed entity", entityGroupOne);
        MockProblemChangeDirector mockProblemChangeDirector = new MockProblemChangeDirector();
        mockProblemChangeDirector.whenLookingUp((Object)removedEntity).thenReturn((Object)removedWorkingEntity).whenLookingUp((Object)removedFact).thenReturn((Object)removedWorkingFact).whenLookingUp((Object)changedEntity).thenReturn((Object)changedWorkingEntity);
        ProblemChange problemChange = (workingSolution, problemChangeDirector) -> {
            problemChangeDirector.addEntity((Object)addedEntity, workingSolution.getEntityList()::add);
            problemChangeDirector.removeEntity((Object)removedEntity, workingSolution.getEntityList()::remove);
            problemChangeDirector.changeVariable((Object)changedEntity, "value", testdataEntity -> testdataEntity.setValue(changedFact));
            problemChangeDirector.changeProblemProperty((Object)changedEntity, workingEntity -> workingEntity.setEntityGroup(null));
            problemChangeDirector.addProblemFact((Object)addedFact, workingSolution.getValueList()::add);
            problemChangeDirector.removeProblemFact((Object)removedFact, workingSolution.getValueList()::remove);
        };
        TestdataLavishSolution testdataSolution = TestdataLavishSolution.generateSolution();
        testdataSolution.getEntityList().add(removedWorkingEntity);
        testdataSolution.getEntityList().add(changedWorkingEntity);
        testdataSolution.getValueList().add(removedWorkingFact);
        problemChange.doChange((Object)testdataSolution, (ProblemChangeDirector)mockProblemChangeDirector);
        SoftAssertions.assertSoftly(softAssertions -> {
            softAssertions.assertThat(testdataSolution.getEntityList()).doesNotContain((Object[])new TestdataLavishEntity[]{removedWorkingEntity});
            softAssertions.assertThat(testdataSolution.getValueList()).doesNotContain((Object[])new TestdataLavishValue[]{removedWorkingFact});
            softAssertions.assertThat((Object)changedWorkingEntity.getValue()).isEqualTo((Object)changedFact);
            softAssertions.assertThat((Object)changedWorkingEntity.getEntityGroup()).isNull();
        });
    }
}

