/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Parameter;
import org.kie.workbench.common.services.datamodeller.driver.MethodFilter;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;

@ApplicationScoped
public class PlannerMethodFilter
implements MethodFilter {
    private static Set<String> BENDABLE_SCORE_TYPES = new HashSet<String>();

    public boolean accept(Method<?, ?> method) {
        return !method.isConstructor() && method.getAnnotation(Generated.class) != null && (this.isGetScoreMethod(method) || this.isSetScoreMethod(method) || this.isCompareMethod(method));
    }

    private boolean isGetScoreMethod(Method<?, ?> method) {
        return "getScore".equals(method.getName()) && (method.getParameters() == null || method.getParameters().isEmpty()) && method.getReturnType() != null && BENDABLE_SCORE_TYPES.contains(method.getReturnType().getName());
    }

    private boolean isSetScoreMethod(Method<?, ?> method) {
        return "setScore".equals(method.getName()) && method.getParameters() != null && method.getParameters().size() == 1 && BENDABLE_SCORE_TYPES.contains(((Parameter)method.getParameters().get(0)).getType().getName()) && (method.getReturnType() == null || method.getReturnType().getName().equals("void"));
    }

    private boolean isCompareMethod(Method<?, ?> method) {
        return "compare".equals(method.getName()) && method.getParameters() != null && method.getParameters().size() == 2 && method.getReturnType() != null && method.getReturnType().getName().equals("int");
    }

    static {
        BENDABLE_SCORE_TYPES.add(BendableScore.class.getName());
        BENDABLE_SCORE_TYPES.add(BendableScore.class.getSimpleName());
        BENDABLE_SCORE_TYPES.add(BendableLongScore.class.getName());
        BENDABLE_SCORE_TYPES.add(BendableLongScore.class.getSimpleName());
        BENDABLE_SCORE_TYPES.add(BendableBigDecimalScore.class.getName());
        BENDABLE_SCORE_TYPES.add(BendableBigDecimalScore.class.getSimpleName());
    }
}

