/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.validation.SaveValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningSolutionToBeDuplicatedMessage;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class PlanningSolutionSaveValidator
implements SaveValidator<DataObject> {
    private DataModelerService dataModelerService;

    @Inject
    public PlanningSolutionSaveValidator(DataModelerService dataModelerService) {
        this.dataModelerService = dataModelerService;
    }

    public Collection<ValidationMessage> validate(Path dataObjectPath, DataObject dataObject) {
        if (dataObject != null && dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
            List planningSolutionUsages = this.dataModelerService.findClassUsages(dataObjectPath, "org.optaplanner.core.api.domain.solution.PlanningSolution");
            if (planningSolutionUsages.contains(dataObjectPath)) {
                return Collections.emptyList();
            }
            if (!planningSolutionUsages.isEmpty()) {
                return Arrays.asList(new PlanningSolutionToBeDuplicatedMessage(Level.ERROR));
            }
        }
        return Collections.emptyList();
    }

    public boolean accept(Path path) {
        return path.getFileName().endsWith(".java");
    }
}

