/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend;

import java.util.Arrays;
import java.util.Collection;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.refactoring.service.AssetsUsageService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.PlanningSolutionScoreHolderDeleteValidator;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.ScoreHolderUtils;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalToBeRemovedMessage;
import org.optaplanner.workbench.screens.domaineditor.validation.ScoreHolderGlobalTypeNotRecognizedMessage;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionScoreHolderDeleteValidatorTest {
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private AssetsUsageService assetsUsageService;
    @Mock
    private IOService ioService;
    @Mock
    private ScoreHolderUtils scoreHolderUtils;
    private PlanningSolutionScoreHolderDeleteValidator validator;

    @Before
    public void setUp() {
        this.validator = new PlanningSolutionScoreHolderDeleteValidator(this.dataModelerService, this.ioService, this.scoreHolderUtils, this.assetsUsageService);
    }

    @Test
    public void planningSolution() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObjectImpl originalDataObject = new DataObjectImpl("test", "Test");
        originalDataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn((DataObject)originalDataObject)).thenReturn((Object)HardSoftScore.class.getName());
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn(HardSoftScore.class.getName())).thenReturn((Object)HardSoftScoreHolder.class.getName());
        Mockito.when((Object)this.assetsUsageService.getAssetUsages(HardSoftScoreHolder.class.getName(), ResourceType.JAVA, dataObjectPath)).thenReturn(Arrays.asList((Path)Mockito.mock(Path.class)));
        DataObjectImpl updatedDataObject = new DataObjectImpl("test", "Test");
        updatedDataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        Collection result = this.validator.validate(dataObjectPath, (DataObject)updatedDataObject);
        Assert.assertEquals((long)1L, (long)result.size());
        ValidationMessage message = (ValidationMessage)result.iterator().next();
        Assert.assertTrue((boolean)(message instanceof ScoreHolderGlobalToBeRemovedMessage));
    }

    @Test
    public void notAPlanningSolution() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObjectImpl originalDataObject = new DataObjectImpl("test", "Test");
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        DataObjectImpl updatedDataObject = new DataObjectImpl("test", "Test");
        Collection result = this.validator.validate(dataObjectPath, (DataObject)updatedDataObject);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void scoreHolderTypeNotRecognized() {
        Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((Path)dataObjectPath))).thenReturn((Object)"testResult");
        DataObjectImpl originalDataObject = new DataObjectImpl("test", "Test");
        originalDataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)originalDataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((Path)Matchers.any(), Matchers.anyString(), (Path)Matchers.any())).thenReturn((Object)generationResult);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn((DataObject)originalDataObject)).thenReturn((Object)"UnknownScoreClassName");
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn("UnknownScoreClassName")).thenReturn(null);
        DataObjectImpl updatedDataObject = new DataObjectImpl("test", "Test");
        Collection result = this.validator.validate(dataObjectPath, (DataObject)updatedDataObject);
        Assert.assertEquals((long)1L, (long)result.size());
        ValidationMessage message = (ValidationMessage)result.iterator().next();
        Assert.assertTrue((boolean)(message instanceof ScoreHolderGlobalTypeNotRecognizedMessage));
    }
}

