/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.helper;

import org.guvnor.common.services.project.model.Package;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.workbench.screens.domaineditor.backend.server.helper.PlanningSolutionCopyHelper;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionCopyHelperTest {
    @Mock
    private IOService ioService;
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private KieModuleService kieModuleService;
    private org.uberfire.backend.vfs.Path sourcePath;
    private org.uberfire.backend.vfs.Path destinationPath;
    private GenerationResult generationResult;
    private PlanningSolutionCopyHelper copyHelper;

    @Before
    public void setUp() {
        this.generationResult = new GenerationResult();
        this.copyHelper = new PlanningSolutionCopyHelper(this.ioService, this.dataModelerService, this.kieModuleService);
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)this.sourcePath))).thenReturn((Object)"test source");
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.generationResult);
        this.sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        this.destinationPath = PathFactory.newPath((String)"TestDestination.java", (String)"file:///dataObjects");
    }

    @Test
    public void postProcess() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "TestSource");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        this.generationResult.setDataObject((DataObject)dataObject);
        Package _package = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)_package.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"dataObjects", (String)"file:///dataObjects"));
        Mockito.when((Object)this.kieModuleService.resolvePackage(this.sourcePath)).thenReturn((Object)_package);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any())).thenReturn((Object)true);
        this.copyHelper.postProcess(this.sourcePath, this.destinationPath);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).copy((Path)Matchers.any(Path.class), (Path)Matchers.any(Path.class), new CopyOption[0]);
    }

    @Test
    public void sourceDataObjectIsNull() {
        this.generationResult.setDataObject(null);
        this.copyHelper.postProcess(this.sourcePath, this.destinationPath);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).exists((Path)Matchers.any());
    }

    @Test
    public void sourceDataObjectIsNotPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "TestSource");
        this.generationResult.setDataObject((DataObject)dataObject);
        this.copyHelper.postProcess(this.sourcePath, this.destinationPath);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).exists((Path)Matchers.any());
    }
}

