/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.helper;

import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.workbench.screens.domaineditor.backend.server.helper.PlanningSolutionSaveHelper;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.ScoreHolderUtils;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PlanningSolutionSaveHelperTest {
    @Mock
    private IOService ioService;
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private GlobalsEditorService globalsEditorService;
    @Mock
    private KieModuleService kieModuleService;
    @Mock
    private ScoreHolderUtils scoreHolderUtils;
    @Mock
    private MetadataService metadataService;
    private PlanningSolutionSaveHelper saveHelper;

    @Before
    public void setUp() {
        this.saveHelper = new PlanningSolutionSaveHelper(this.ioService, this.dataModelerService, this.globalsEditorService, this.kieModuleService, this.scoreHolderUtils, this.metadataService);
    }

    @Test
    public void scoreTypeChangedScoreHolderGlobalFileExisting() {
        org.uberfire.backend.vfs.Path sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        org.uberfire.backend.vfs.Path destinationPath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        this.testPlanningSolutionSaved(true, sourcePath, destinationPath);
    }

    @Test
    public void scoreTypeChangedScoreHolderGlobalFileNonExisting() {
        org.uberfire.backend.vfs.Path sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        org.uberfire.backend.vfs.Path destinationPath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        this.testPlanningSolutionSaved(false, sourcePath, destinationPath);
    }

    @Test
    public void planningSolutionDataObjectRenamed() {
        org.uberfire.backend.vfs.Path sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects1");
        org.uberfire.backend.vfs.Path destinationPath = PathFactory.newPath((String)"TestDestination.java", (String)"file:///dataObjects2");
        this.testPlanningSolutionSaved(false, sourcePath, destinationPath);
    }

    private void testPlanningSolutionSaved(boolean scoreHolderGlobalFileExists, org.uberfire.backend.vfs.Path sourcePath, org.uberfire.backend.vfs.Path destinationPath) {
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)sourcePath))).thenReturn((Object)"test source");
        DataObjectImpl dataObject = new DataObjectImpl("test", "TestSource");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)dataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Package _package = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)_package.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"dataObjects", (String)"file:///dataObjects"));
        Mockito.when((Object)this.kieModuleService.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)_package);
        Mockito.when((Object)this.scoreHolderUtils.extractScoreTypeFqn((DataObject)dataObject)).thenReturn((Object)HardSoftScore.class.getName());
        Mockito.when((Object)this.scoreHolderUtils.getScoreHolderTypeFqn(HardSoftScore.class.getName())).thenReturn((Object)HardSoftScoreHolder.class.getName());
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any())).thenReturn((Object)scoreHolderGlobalFileExists);
        Mockito.when((Object)this.globalsEditorService.load((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn(Mockito.mock(GlobalsModel.class));
        this.saveHelper.postProcess(sourcePath, destinationPath);
        if (sourcePath.equals(destinationPath)) {
            if (scoreHolderGlobalFileExists) {
                ((GlobalsEditorService)Mockito.verify((Object)this.globalsEditorService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.any(GlobalsModel.class), Matchers.any(Metadata.class), Matchers.anyString());
            } else {
                ((GlobalsEditorService)Mockito.verify((Object)this.globalsEditorService, (VerificationMode)Mockito.times((int)1))).generate((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.anyString(), (GlobalsModel)Matchers.any(GlobalsModel.class), Matchers.anyString());
            }
        } else {
            ((IOService)Mockito.verify((Object)this.ioService)).deleteIfExists((Path)Matchers.any(Path.class), new DeleteOption[0]);
        }
    }

    @Test
    public void saveDataObjectIsNull() {
        org.uberfire.backend.vfs.Path sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        org.uberfire.backend.vfs.Path destinationPath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)sourcePath))).thenReturn((Object)"test source");
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(null);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Package _package = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)_package.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"dataObjects", (String)"file:///dataObjects"));
        Mockito.when((Object)this.kieModuleService.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)_package);
        this.saveHelper.postProcess(sourcePath, destinationPath);
        ((ScoreHolderUtils)Mockito.verify((Object)this.scoreHolderUtils, (VerificationMode)Mockito.never())).extractScoreTypeFqn((DataObject)Matchers.any());
    }

    @Test
    public void saveDataObjectNotAPlanningSolution() {
        org.uberfire.backend.vfs.Path sourcePath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        org.uberfire.backend.vfs.Path destinationPath = PathFactory.newPath((String)"TestSource.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)sourcePath))).thenReturn((Object)"test source");
        DataObjectImpl dataObject = new DataObjectImpl("test", "TestSource");
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject((DataObject)dataObject);
        Mockito.when((Object)this.dataModelerService.loadDataObject((org.uberfire.backend.vfs.Path)Matchers.any(), Matchers.anyString(), (org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)generationResult);
        Package _package = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)_package.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"dataObjects", (String)"file:///dataObjects"));
        Mockito.when((Object)this.kieModuleService.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)_package);
        this.saveHelper.postProcess(sourcePath, destinationPath);
        ((IOService)Mockito.verify((Object)this.ioService)).deleteIfExists((Path)Matchers.any(Path.class), new DeleteOption[0]);
    }
}

