/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.Parameter;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ParameterImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.TypeImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.optaplanner.workbench.screens.domaineditor.backend.server.ComparatorDefinitionServiceImpl;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.optaplanner.workbench.screens.domaineditor.service.ComparatorDefinitionService;

public class ComparatorDefinitionServiceTest {
    private ComparatorDefinitionService comparatorDefinitionService = new ComparatorDefinitionServiceImpl();

    @Test
    public void createComparatorObject() {
        JavaClass comparatorObject = this.comparatorDefinitionService.createComparatorObject((DataObject)new DataObjectImpl("foo.bar", "TestDataObject"));
        Assert.assertEquals((Object)"DifficultyComparator", (Object)comparatorObject.getName());
        Assert.assertTrue((boolean)comparatorObject.getInterfaces().contains("java.util.Comparator<foo.bar.TestDataObject>"));
        List comparatorObjectMethods = comparatorObject.getMethods();
        Assert.assertNotNull((Object)comparatorObjectMethods);
        Assert.assertEquals((long)1L, (long)comparatorObjectMethods.size());
        Method compareMethod = (Method)comparatorObjectMethods.get(0);
        Assert.assertEquals((Object)"compare", (Object)compareMethod.getName());
        Assert.assertEquals((Object)"int", (Object)compareMethod.getReturnType().getName());
        Assert.assertEquals((Object)"int", (Object)compareMethod.getReturnType().getName());
        Assert.assertEquals((long)2L, (long)compareMethod.getParameters().size());
        Assert.assertEquals((Object)"foo.bar.TestDataObject", (Object)((Parameter)compareMethod.getParameters().get(0)).getType().getName());
        Assert.assertEquals((Object)"o1", (Object)((Parameter)compareMethod.getParameters().get(0)).getName());
        Assert.assertEquals((Object)"foo.bar.TestDataObject", (Object)((Parameter)compareMethod.getParameters().get(1)).getType().getName());
        Assert.assertEquals((Object)"o2", (Object)((Parameter)compareMethod.getParameters().get(1)).getName());
    }

    @Test
    public void updateComparatorObject() {
        DataObjectImpl dataObject = new DataObjectImpl("foo.bar", "TestDataObject");
        JavaClassImpl comparatorObject = new JavaClassImpl("", "DifficultyComparator");
        ParameterImpl parameter1 = new ParameterImpl((Type)new TypeImpl("TestDataObject"), "o1");
        ParameterImpl parameter2 = new ParameterImpl((Type)new TypeImpl("TestDataObject"), "o2");
        MethodImpl compareMethod = new MethodImpl("compare", Arrays.asList(parameter1, parameter2), "foo", (Type)new TypeImpl("int"), Visibility.PUBLIC);
        comparatorObject.addMethod((Method)compareMethod);
        comparatorObject.addInterface("java.util.Comparator<foo.bar.TestDataObject>");
        dataObject.addNestedClass((JavaClass)comparatorObject);
        comparatorObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(ComparatorDefinition.class)));
        dataObject.setName("TestDataObjectUpdated");
        JavaClass updatedComparatorObject = this.comparatorDefinitionService.updateComparatorObject((DataObject)dataObject, (JavaClass)comparatorObject);
        Assert.assertTrue((boolean)updatedComparatorObject.getInterfaces().contains("java.util.Comparator<foo.bar.TestDataObjectUpdated>"));
    }
}

