/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.kie.workbench.common.screens.datamodeller.backend.server.indexing.JavaFileIndexerExtension;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.workbench.screens.domaineditor.model.ComparatorDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ComparatorDefinitionIndexerExtension
implements JavaFileIndexerExtension {
    private static final Logger logger = LoggerFactory.getLogger(ComparatorDefinitionIndexerExtension.class);

    public void process(DefaultIndexBuilder builder, JavaType javaType) {
        try {
            Annotation planningEntityAnnotation = javaType.getAnnotation(PlanningEntity.class.getName());
            if (planningEntityAnnotation == null) {
                return;
            }
            String difficultyComparatorClass = planningEntityAnnotation.getStringValue("difficultyComparatorClass");
            if (difficultyComparatorClass == null || !(javaType instanceof JavaClassSource) || !difficultyComparatorClass.matches("\\w[\\.\\w]+\\.class")) {
                return;
            }
            String[] difficultyComparatorTokens = difficultyComparatorClass.split("\\.");
            List comparatorDefinitions = ((JavaClassSource)javaType).getNestedTypes().stream().filter(t -> t instanceof JavaClassSource && t.getName().equals(difficultyComparatorTokens[difficultyComparatorTokens.length - 2]) && t.getAnnotation(ComparatorDefinition.class.getName()) != null && t.getAnnotation(Generated.class.getName()) != null && ((JavaClassSource)t).getInterfaces().stream().anyMatch(i -> i.startsWith(Comparator.class.getName()))).map(t -> t.getAnnotation(ComparatorDefinition.class.getName())).collect(Collectors.toList());
            if (javaType.getSyntaxErrors() == null || javaType.getSyntaxErrors().isEmpty()) {
                for (Annotation comparatorDefinition : comparatorDefinitions) {
                    Annotation[] fieldPathDefinitions = comparatorDefinition.getAnnotationArrayValue("objectPropertyPaths");
                    String previousFullyQualifiedClassname = null;
                    if (fieldPathDefinitions == null) continue;
                    for (Annotation fieldPathDefinition : fieldPathDefinitions) {
                        Annotation[] fieldDefinitions = fieldPathDefinition.getAnnotationArrayValue("objectProperties");
                        if (fieldDefinitions == null || fieldDefinitions.length <= 0 || (previousFullyQualifiedClassname = fieldDefinitions[0].getStringValue("type")) == null || !previousFullyQualifiedClassname.matches("\\w[\\.\\w]+\\.class")) continue;
                        for (int i = 1; i < fieldDefinitions.length; ++i) {
                            ResourceReference resourceReference = new ResourceReference(previousFullyQualifiedClassname.substring(0, previousFullyQualifiedClassname.indexOf(".class")), ResourceType.JAVA);
                            resourceReference.addPartReference(fieldDefinitions[i].getStringValue("name"), PartType.FIELD);
                            previousFullyQualifiedClassname = fieldDefinitions[i].getStringValue("type");
                            builder.addGenerator((IndexElementsGenerator)resourceReference);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to index comparator definition for " + javaType.getQualifiedName());
        }
    }
}

