/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.helper;

import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.kie.workbench.common.screens.datamodeller.backend.server.helper.DataModelerSaveHelper;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.ScoreHolderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class PlanningSolutionSaveHelper
implements DataModelerSaveHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanningSolutionSaveHelper.class);
    private static final String SCORE_HOLDER = "scoreHolder";
    private static final String SCORE_HOLDER_GLOBAL_FILE_SUFFIX = "ScoreHolderGlobal.gdrl";
    private DataModelerService dataModelerService;
    private IOService ioService;
    private GlobalsEditorService globalsEditorService;
    private KieProjectService kieProjectService;
    private ScoreHolderUtils scoreHolderUtils;
    private MetadataService metadataService;

    public PlanningSolutionSaveHelper() {
    }

    @Inject
    public PlanningSolutionSaveHelper(@Named(value="ioStrategy") IOService ioService, DataModelerService dataModelerService, GlobalsEditorService globalsEditorService, KieProjectService kieProjectService, ScoreHolderUtils scoreHolderUtils, MetadataService metadataService) {
        this.ioService = ioService;
        this.dataModelerService = dataModelerService;
        this.globalsEditorService = globalsEditorService;
        this.kieProjectService = kieProjectService;
        this.scoreHolderUtils = scoreHolderUtils;
        this.metadataService = metadataService;
    }

    public void postProcess(org.uberfire.backend.vfs.Path sourcePath, org.uberfire.backend.vfs.Path destinationPath) {
        String dataObjectSource = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)destinationPath));
        GenerationResult generationResult = this.dataModelerService.loadDataObject(destinationPath, dataObjectSource, destinationPath);
        Path source = Paths.convert((org.uberfire.backend.vfs.Path)this.kieProjectService.resolvePackage(sourcePath).getPackageMainResourcesPath());
        Path sourcePackage = Files.isDirectory((Path)source, (LinkOption[])new LinkOption[0]) ? source : source.getParent();
        String sourceSolutionFileName = sourcePath.getFileName().substring(0, sourcePath.getFileName().indexOf("."));
        Path sourceScoreHolderGlobalPath = sourcePackage.resolve(sourceSolutionFileName + SCORE_HOLDER_GLOBAL_FILE_SUFFIX);
        if (generationResult.hasErrors()) {
            LOGGER.warn("Path " + destinationPath + " parsing as a data object has failed. Score holder global generation will be skipped.");
        } else {
            DataObject dataObject = generationResult.getDataObject();
            if (dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
                String sourceScoreTypeFqn = this.scoreHolderUtils.extractScoreTypeFqn(dataObject);
                String scoreHolderTypeFqn = this.scoreHolderUtils.getScoreHolderTypeFqn(sourceScoreTypeFqn);
                if (scoreHolderTypeFqn == null) {
                    LOGGER.warn("'scoreHolder' global variable will not be generated, as the selected score type is not supported");
                    return;
                }
                if (sourcePath.equals(destinationPath)) {
                    boolean scoreHolderGlobalFileExists = this.ioService.exists(sourceScoreHolderGlobalPath);
                    if (scoreHolderGlobalFileExists) {
                        GlobalsModel globalsModel = (GlobalsModel)this.globalsEditorService.load(Paths.convert((Path)sourceScoreHolderGlobalPath));
                        globalsModel.setGlobals(Arrays.asList(new Global(SCORE_HOLDER, scoreHolderTypeFqn)));
                        this.globalsEditorService.save(Paths.convert((Path)sourceScoreHolderGlobalPath), (Object)globalsModel, this.metadataService.getMetadata(Paths.convert((Path)sourceScoreHolderGlobalPath)), "Auto generate scoreHolder global");
                    } else {
                        this.createScoreHolderGlobalFile(Paths.convert((Path)sourcePackage), scoreHolderTypeFqn, sourceSolutionFileName);
                    }
                } else {
                    Path destination = Paths.convert((org.uberfire.backend.vfs.Path)this.kieProjectService.resolvePackage(destinationPath).getPackageMainResourcesPath());
                    Path destinationPackage = Files.isDirectory((Path)destination, (LinkOption[])new LinkOption[0]) ? destination : destination.getParent();
                    this.ioService.deleteIfExists(sourceScoreHolderGlobalPath, new DeleteOption[0]);
                    String destinationScoreHolderFileSimpleName = destinationPath.getFileName().substring(0, destinationPath.getFileName().indexOf("."));
                    this.createScoreHolderGlobalFile(Paths.convert((Path)destinationPackage), scoreHolderTypeFqn, destinationScoreHolderFileSimpleName);
                }
            } else {
                this.ioService.deleteIfExists(sourceScoreHolderGlobalPath, new DeleteOption[0]);
            }
        }
    }

    private void createScoreHolderGlobalFile(org.uberfire.backend.vfs.Path folderPath, String scoreHolderTypeFqn, String solutionFileName) {
        GlobalsModel globalsModel = new GlobalsModel();
        globalsModel.setGlobals(Arrays.asList(new Global(SCORE_HOLDER, scoreHolderTypeFqn)));
        this.globalsEditorService.generate(folderPath, solutionFileName + SCORE_HOLDER_GLOBAL_FILE_SUFFIX, globalsModel, "Auto generate Score holder global variable based on a @PlanningSolution " + solutionFileName);
    }
}

