/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.validation;

import java.util.Collection;
import javax.annotation.Generated;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.workbench.screens.domaineditor.backend.server.validation.PlanningScoreDeleteValidator;
import org.optaplanner.workbench.screens.domaineditor.validation.PlanningScoreToBeDeletedMessage;

public class PlanningScoreDeleteValidatorTest {
    private PlanningScoreDeleteValidator deleteValidator;

    @Before
    public void setUp() {
        this.deleteValidator = new PlanningScoreDeleteValidator();
    }

    @Test
    public void validateIsAPlanningScore() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "PlanningSolution");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        ObjectPropertyImpl objectProperty = new ObjectPropertyImpl("score", HardSoftScore.class.getName(), false);
        objectProperty.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningScore.class)));
        objectProperty.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(Generated.class)));
        Collection result = this.deleteValidator.validate((DataObject)dataObject, (ObjectProperty)objectProperty);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.iterator().next() instanceof PlanningScoreToBeDeletedMessage));
    }

    @Test
    public void validateIsNotAPlanningScore() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "PlainDataObject");
        ObjectPropertyImpl objectProperty = new ObjectPropertyImpl("notAPlanningScore", Integer.class.getName(), false);
        Collection result = this.deleteValidator.validate((DataObject)dataObject, (ObjectProperty)objectProperty);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void validateNullObject() {
        Assert.assertEquals((long)0L, (long)this.deleteValidator.validate(null, null).size());
    }

    @Test
    public void validateNullProperty() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "PlanningSolution");
        dataObject.addAnnotation((Annotation)new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class)));
        Assert.assertEquals((long)0L, (long)this.deleteValidator.validate((DataObject)dataObject, null).size());
    }
}

