/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.domaineditor.backend.server.helper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datamodeller.backend.server.helper.DataModelerRenameWorkaroundHelper;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class PlanningSolutionRenameWorkaroundHelper
implements DataModelerRenameWorkaroundHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanningSolutionRenameWorkaroundHelper.class);
    private static final String SCORE_HOLDER_GLOBAL_FILE_SUFFIX = "ScoreHolderGlobal.gdrl";
    private IOService ioService;
    private DataModelerService dataModelerService;
    private KieModuleService kieModuleService;

    public PlanningSolutionRenameWorkaroundHelper() {
    }

    @Inject
    public PlanningSolutionRenameWorkaroundHelper(@Named(value="ioStrategy") IOService ioService, DataModelerService dataModelerService, KieModuleService kieModuleService) {
        this.ioService = ioService;
        this.dataModelerService = dataModelerService;
        this.kieModuleService = kieModuleService;
    }

    public void postProcess(org.uberfire.backend.vfs.Path sourcePath, org.uberfire.backend.vfs.Path destinationPath) {
        String dataObjectSource = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)destinationPath));
        GenerationResult generationResult = this.dataModelerService.loadDataObject(destinationPath, dataObjectSource, destinationPath);
        if (generationResult.hasErrors()) {
            LOGGER.warn("Path " + sourcePath + " parsing as a data object has failed. Score holder global generation will be skipped.");
        } else {
            DataObject dataObject = generationResult.getDataObject();
            if (dataObject != null && dataObject.getAnnotation("org.optaplanner.core.api.domain.solution.PlanningSolution") != null) {
                Path source = Paths.convert((org.uberfire.backend.vfs.Path)this.kieModuleService.resolvePackage(sourcePath).getPackageMainResourcesPath());
                Path sourcePackage = Files.isDirectory((Path)source, (LinkOption[])new LinkOption[0]) ? source : source.getParent();
                String sourceDataObjectFileName = sourcePath.getFileName().substring(0, sourcePath.getFileName().indexOf("."));
                Path destination = Paths.convert((org.uberfire.backend.vfs.Path)this.kieModuleService.resolvePackage(destinationPath).getPackageMainResourcesPath());
                Path destinationPackage = Files.isDirectory((Path)destination, (LinkOption[])new LinkOption[0]) ? destination : destination.getParent();
                String destinationDataObjectFileName = destinationPath.getFileName().substring(0, destinationPath.getFileName().indexOf("."));
                boolean scoreHolderGlobalFileExists = this.ioService.exists(sourcePackage.resolve(sourceDataObjectFileName + SCORE_HOLDER_GLOBAL_FILE_SUFFIX));
                if (scoreHolderGlobalFileExists) {
                    this.ioService.move(sourcePackage.resolve(sourceDataObjectFileName + SCORE_HOLDER_GLOBAL_FILE_SUFFIX), destinationPackage.resolve(destinationDataObjectFileName + SCORE_HOLDER_GLOBAL_FILE_SUFFIX), new CopyOption[0]);
                }
            }
        }
    }
}

