/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import java.util.Arrays;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.MultiConstraintHardSoftMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.UnknownIAction;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionHardConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMediumConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintBendableBigDecimalMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintBendableLongMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintHardMediumSoftMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionMultiConstraintHardSoftMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionSoftConstraintMatch;

public class MultiConstraintMatchPersistenceExtensionTest {
    private MultiConstraintHardSoftMatchPersistenceExtension extension = new MultiConstraintHardSoftMatchPersistenceExtension();

    @Test
    public void acceptIAction() {
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionMultiConstraintHardSoftMatch()));
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionMultiConstraintHardMediumSoftMatch()));
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionMultiConstraintBendableMatch()));
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionMultiConstraintBendableLongMatch()));
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionMultiConstraintBendableBigDecimalMatch()));
        Assert.assertFalse((boolean)this.extension.accept((IAction)new UnknownIAction()));
    }

    @Test
    public void marshalActionMultiConstraintHardSoftMatch() {
        ActionMultiConstraintHardSoftMatch action = new ActionMultiConstraintHardSoftMatch(new ActionHardConstraintMatch("-1"), new ActionSoftConstraintMatch("-2"));
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintHardMediumSoftMatch() {
        ActionMultiConstraintHardMediumSoftMatch action = new ActionMultiConstraintHardMediumSoftMatch(new ActionHardConstraintMatch("-1"), new ActionMediumConstraintMatch("-2"), new ActionSoftConstraintMatch("-3"));
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintBendableMatch() {
        ActionMultiConstraintBendableMatch action = new ActionMultiConstraintBendableMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1"), new ActionBendableHardConstraintMatch(1, "-2")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3"), new ActionBendableSoftConstraintMatch(1, "-4")));
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintBendableLongMatch() {
        ActionMultiConstraintBendableLongMatch action = new ActionMultiConstraintBendableLongMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1l"), new ActionBendableHardConstraintMatch(1, "-2l")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3l"), new ActionBendableSoftConstraintMatch(1, "-4l")));
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintBendableBigDecimalMatch() {
        ActionMultiConstraintBendableBigDecimalMatch action = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "new java.math.BigDecimal(-1)"), new ActionBendableHardConstraintMatch(1, "new java.math.BigDecimal(-2)")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "new java.math.BigDecimal(-3)"), new ActionBendableSoftConstraintMatch(1, "new java.math.BigDecimal(-4)")));
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});", (Object)marshaledAction);
    }

    @Test(expected=IllegalArgumentException.class)
    public void marshalUnknownIAction() {
        this.extension.marshal((IAction)new UnknownIAction());
    }

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalActionMultiConstraintHardSoftMatch() {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardSoftMatch));
        ActionMultiConstraintHardSoftMatch actionActionMultiConstraintHardSoftMatch = (ActionMultiConstraintHardSoftMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionActionMultiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-2", (Object)actionActionMultiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintHardMediumSoftMatch() {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionMultiConstraintHardMediumSoftMatch));
        ActionMultiConstraintHardMediumSoftMatch actionActionMultiConstraintHardMediumSoftMatch = (ActionMultiConstraintHardMediumSoftMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-2", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionMediumConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"-3", (Object)actionActionMultiConstraintHardMediumSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void unmarshalActionMultiConstraintBendableMatch() {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4});";
        IAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableMatch expectedAction = new ActionMultiConstraintBendableMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1"), new ActionBendableHardConstraintMatch(1, "-2")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3"), new ActionBendableSoftConstraintMatch(1, "-4")));
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableLongMatch() {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l});";
        IAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableLongMatch expectedAction = new ActionMultiConstraintBendableLongMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1l"), new ActionBendableHardConstraintMatch(1, "-2l")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3l"), new ActionBendableSoftConstraintMatch(1, "-4l")));
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }

    @Test
    public void unmarshalActionMultiConstraintBendableBigDecimalMatch() {
        String actionString = "scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)});";
        IAction action = this.extension.unmarshal(actionString);
        ActionMultiConstraintBendableBigDecimalMatch expectedAction = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "new java.math.BigDecimal(-1)"), new ActionBendableHardConstraintMatch(1, "new java.math.BigDecimal(-2)")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "new java.math.BigDecimal(-3)"), new ActionBendableSoftConstraintMatch(1, "new java.math.BigDecimal(-4)")));
        Assert.assertEquals((Object)expectedAction, (Object)action);
    }
}

