/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.drools.workbench.screens.globals.model.Global;
import org.drools.workbench.screens.globals.model.GlobalsModel;
import org.drools.workbench.screens.globals.service.GlobalsEditorService;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.javaeditor.type.JavaResourceTypeDefinition;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.TypeImpl;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.core.api.domain.solution.PlanningScore;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.workbench.screens.guidedrule.backend.server.service.ScoreHolderServiceImpl;
import org.optaplanner.workbench.screens.guidedrule.model.BendableScoreLevelsWrapper;
import org.optaplanner.workbench.screens.guidedrule.model.ScoreInformation;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScoreHolderServiceImplTest {
    @Mock
    private KieProjectService kieProjectService;
    @Mock
    private IOService ioService;
    @Mock
    private GlobalsEditorService globalsEditorService;
    @Mock
    private DataModelerService dataModelerService;
    @Mock
    private JavaResourceTypeDefinition javaResourceTypeDefinition;
    @InjectMocks
    private ScoreHolderServiceImpl scoreHolderService;

    @Test
    public void getProjectScoreInformation() {
        org.uberfire.backend.vfs.Path dataObjectPath = PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects");
        Mockito.when((Object)this.dataModelerService.findClassUsages(dataObjectPath, PlanningSolution.class.getName())).thenReturn(Arrays.asList(dataObjectPath));
        Mockito.when((Object)this.javaResourceTypeDefinition.accept(dataObjectPath)).thenReturn((Object)true);
        Package resourcesPackage = (Package)Mockito.mock(Package.class);
        Mockito.when((Object)resourcesPackage.getPackageMainResourcesPath()).thenReturn((Object)PathFactory.newPath((String)"Test.java", (String)"file:///dataObjects"));
        Mockito.when((Object)this.kieProjectService.resolvePackage(dataObjectPath)).thenReturn((Object)resourcesPackage);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.any(Path.class))).thenReturn((Object)true);
        GlobalsModel globalsModel = new GlobalsModel();
        globalsModel.setGlobals(Arrays.asList(new Global("scoreHolder", BendableScore.class.getName())));
        Mockito.when((Object)this.globalsEditorService.load((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn((Object)globalsModel);
        Mockito.when((Object)this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)dataObjectPath))).thenReturn((Object)"testContent");
        GenerationResult generationResult = new GenerationResult();
        generationResult.setDataObject(this.createPlanningSolution());
        Mockito.when((Object)this.dataModelerService.loadDataObject(dataObjectPath, "testContent", dataObjectPath)).thenReturn((Object)generationResult);
        ScoreInformation scoreInformation = this.scoreHolderService.getProjectScoreInformation(dataObjectPath);
        Assert.assertNotNull((Object)scoreInformation);
        Collection scoreHolderFqnTypeFqns = scoreInformation.getScoreHolderFqnTypeFqns();
        Assert.assertNotNull((Object)scoreHolderFqnTypeFqns);
        Assert.assertEquals((long)1L, (long)scoreHolderFqnTypeFqns.size());
        Assert.assertEquals((Object)BendableScore.class.getName(), scoreHolderFqnTypeFqns.iterator().next());
        Collection bendableScoreLevelsWrappers = scoreInformation.getBendableScoreLevelsWrappers();
        Assert.assertNotNull((Object)bendableScoreLevelsWrappers);
        Assert.assertEquals((long)1L, (long)bendableScoreLevelsWrappers.size());
        BendableScoreLevelsWrapper bendableScoreLevelsWrapper = (BendableScoreLevelsWrapper)bendableScoreLevelsWrappers.iterator().next();
        Assert.assertEquals((long)1L, (long)bendableScoreLevelsWrapper.getHardScoreLevels());
        Assert.assertEquals((long)2L, (long)bendableScoreLevelsWrapper.getSoftScoreLevels());
    }

    private DataObject createPlanningSolution() {
        DataObjectImpl dataObject = new DataObjectImpl("test", "TestSolution");
        AnnotationImpl planningSolutionAnnotation = new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningSolution.class));
        dataObject.addAnnotation((Annotation)planningSolutionAnnotation);
        MethodImpl getScoreMethod = new MethodImpl("getScore", Collections.EMPTY_LIST, "return score;", (Type)new TypeImpl(BendableScore.class.getName()), Visibility.PUBLIC);
        dataObject.addMethod((Method)getScoreMethod);
        AnnotationImpl planningScoreAnnotation = new AnnotationImpl(DriverUtils.buildAnnotationDefinition(PlanningScore.class));
        planningScoreAnnotation.setValue("bendableHardLevelsSize", (Object)1);
        planningScoreAnnotation.setValue("bendableSoftLevelsSize", (Object)2);
        getScoreMethod.addAnnotation((Annotation)planningScoreAnnotation);
        return dataObject;
    }
}

