/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.backend.server.plugin;

import org.drools.workbench.models.datamodel.rule.IAction;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.SoftConstraintMatchPersistenceExtension;
import org.optaplanner.workbench.screens.guidedrule.backend.server.plugin.UnknownIAction;
import org.optaplanner.workbench.screens.guidedrule.model.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.screens.guidedrule.model.ActionSoftConstraintMatch;

public class SoftConstraintMatchPersistenceExtensionTest {
    private SoftConstraintMatchPersistenceExtension extension = new SoftConstraintMatchPersistenceExtension();

    @Test
    public void acceptIAction() {
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionSoftConstraintMatch()));
        Assert.assertTrue((boolean)this.extension.accept((IAction)new ActionBendableSoftConstraintMatch()));
        Assert.assertFalse((boolean)this.extension.accept((IAction)new UnknownIAction()));
    }

    @Test
    public void marshalActionSoftConstraintMatch() {
        ActionSoftConstraintMatch action = new ActionSoftConstraintMatch("-1");
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addSoftConstraintMatch(kcontext, -1);", (Object)marshaledAction);
    }

    @Test
    public void marshalActionBendableSoftConstraintMatch() {
        ActionBendableSoftConstraintMatch action = new ActionBendableSoftConstraintMatch(1, "-1");
        String marshaledAction = this.extension.marshal((IAction)action);
        Assert.assertEquals((Object)"scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);", (Object)marshaledAction);
    }

    @Test(expected=IllegalArgumentException.class)
    public void marshalUnknownIAction() {
        this.extension.marshal((IAction)new UnknownIAction());
    }

    @Test
    public void acceptString() {
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addSoftConstraintMatch(kcontext, -1);"));
        Assert.assertTrue((boolean)this.extension.accept("scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);"));
        Assert.assertFalse((boolean)this.extension.accept("unknownString"));
    }

    @Test
    public void unmarshalSoftConstraintMatch() {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, -1);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionSoftConstraintMatch));
        ActionSoftConstraintMatch actionSoftConstraintMatch = (ActionSoftConstraintMatch)action;
        Assert.assertEquals((Object)"-1", (Object)actionSoftConstraintMatch.getConstraintMatch());
    }

    @Test
    public void unmarshalActionBendableSoftConstraintMatch() {
        String actionString = "scoreHolder.addSoftConstraintMatch(kcontext, 1, -1);";
        IAction action = this.extension.unmarshal(actionString);
        Assert.assertTrue((boolean)(action instanceof ActionBendableSoftConstraintMatch));
        ActionBendableSoftConstraintMatch actionSoftConstraintMatch = (ActionBendableSoftConstraintMatch)action;
        Assert.assertEquals((long)1L, (long)actionSoftConstraintMatch.getPosition());
        Assert.assertEquals((Object)"-1", (Object)actionSoftConstraintMatch.getConstraintMatch());
    }
}

