/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.guidedrule.client.widget;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import java.math.BigDecimal;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.optaplanner.workbench.screens.guidedrule.client.widget.ConstraintMatchInputWidget;

public class ConstraintMatchInputWidgetBlurHandler
implements BlurHandler {
    private ConstraintMatchInputWidget widget;
    private TranslationService translationService;
    private String scoreHolderType;

    public ConstraintMatchInputWidgetBlurHandler(ConstraintMatchInputWidget widget, TranslationService translationService, String scoreHolderType) {
        this.widget = widget;
        this.translationService = translationService;
        this.scoreHolderType = scoreHolderType;
    }

    public void onBlur(BlurEvent event) {
        String inputValue = this.widget.getConstraintMatchValue();
        if (inputValue == null || inputValue.trim().isEmpty()) {
            this.widget.showError(this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.EmptyValuesAreNotAllowedForModifyScore"));
        } else {
            if ((inputValue = inputValue.trim()).matches("-?\\s*\\d+(\\.\\d+)?.*")) {
                switch (this.scoreHolderType) {
                    case "org.optaplanner.core.api.score.buildin.bendable.BendableScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.simple.SimpleScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScoreHolder": {
                        try {
                            Integer.parseInt(inputValue);
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.widget.showError(this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.IntegerValueParsingError"));
                            return;
                        }
                    }
                    case "org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScoreHolder": {
                        try {
                            Long.parseLong(inputValue);
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.widget.showError(this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.LongValueParsingError"));
                            return;
                        }
                    }
                    case "org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardsoftdouble.HardSoftDoubleScoreHolder": {
                        try {
                            Double.parseDouble(inputValue);
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.widget.showError(this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.DoubleValueParsingError"));
                            return;
                        }
                    }
                    case "org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScoreHolder": 
                    case "org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScoreHolder": {
                        try {
                            new BigDecimal(inputValue);
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.widget.showError(this.translationService.getTranslation("ConstraintMatchInputWidgetBlurHandler.BigDecimalValueParsingError"));
                            return;
                        }
                    }
                }
            }
            this.widget.clearError();
        }
    }
}

