/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.optaplanner.workbench.screens.solver.backend.server.ConfigPersistence;
import org.optaplanner.workbench.screens.solver.backend.server.TestUtil;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;
import org.uberfire.io.IOService;

@RunWith(value=MockitoJUnitRunner.class)
public class SolverConfigModelPersistenceTest {
    @Mock
    IOService ioService;
    @InjectMocks
    ConfigPersistence configPersistence;

    @Test
    public void testNew() throws Exception {
        SolverConfigModel config = new SolverConfigModel();
        config.setTerminationConfig(new TerminationConfigModel());
        config.setScoreDirectorFactoryConfig(new ScoreDirectorFactoryConfigModel());
        String xml = this.configPersistence.toXML(config);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.startsWith("<solver"));
        Assert.assertTrue((boolean)xml.contains("<scanAnnotatedClasses"));
        Assert.assertTrue((boolean)xml.endsWith(">"));
    }

    @Test
    public void testTerminationIsNotEmpty() throws Exception {
        SolverConfigModel solverConfigModel = this.configPersistence.toConfig("<solver  />");
        Assert.assertNotNull((Object)solverConfigModel.getTermination());
    }

    @Test
    public void testScoreDirectorFactoryConfigIsNotEmpty() throws Exception {
        SolverConfigModel solverConfigModel = this.configPersistence.toConfig("<solver />");
        Assert.assertNotNull((Object)solverConfigModel.getScoreDirectorFactoryConfig());
    }

    @Test
    public void testFromFile() throws Exception {
        SolverConfigModel config = this.configPersistence.toConfig(TestUtil.loadResource("solver.xml"));
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)30L, (Object)config.getTermination().getSecondsSpentLimit());
    }
}

