/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import org.optaplanner.core.config.domain.ScanAnnotatedClassesConfig;
import org.optaplanner.core.config.score.definition.ScoreDefinitionType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.workbench.screens.solver.model.ScoreDefinitionTypeModel;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;

class ToSolverConfig {
    private SolverConfigModel config;

    public ToSolverConfig(SolverConfigModel config) {
        this.config = config;
    }

    public SolverConfig get() {
        SolverConfig solverConfig = new SolverConfig();
        solverConfig.setScanAnnotatedClassesConfig(new ScanAnnotatedClassesConfig());
        solverConfig.setTerminationConfig(this.create(this.config.getTermination()));
        solverConfig.setScoreDirectorFactoryConfig(this.create(this.config.getScoreDirectorFactoryConfig()));
        return solverConfig;
    }

    private ScoreDirectorFactoryConfig create(ScoreDirectorFactoryConfigModel scoreDirectorFactoryConfig) {
        if (scoreDirectorFactoryConfig == null) {
            return new ScoreDirectorFactoryConfig();
        }
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig();
        config.setScoreDefinitionType(this.create(scoreDirectorFactoryConfig.getScoreDefinitionType()));
        config.setKsessionName(scoreDirectorFactoryConfig.getKSessionName());
        return config;
    }

    private ScoreDefinitionType create(ScoreDefinitionTypeModel scoreDefinitionType) {
        if (scoreDefinitionType != null) {
            for (ScoreDefinitionType model : ScoreDefinitionType.values()) {
                if (!model.name().equals(scoreDefinitionType.name())) continue;
                return model;
            }
        }
        return null;
    }

    private TerminationConfig create(TerminationConfigModel termination) {
        if (termination == null) {
            return new TerminationConfig();
        }
        TerminationConfig terminationConfig = new TerminationConfig();
        terminationConfig.setDaysSpentLimit(termination.getDaysSpentLimit());
        terminationConfig.setHoursSpentLimit(termination.getHoursSpentLimit());
        terminationConfig.setMinutesSpentLimit(termination.getMinutesSpentLimit());
        terminationConfig.setSecondsSpentLimit(termination.getSecondsSpentLimit());
        terminationConfig.setMillisecondsSpentLimit(termination.getMillisecondsSpentLimit());
        terminationConfig.setUnimprovedDaysSpentLimit(termination.getUnimprovedDaysSpentLimit());
        terminationConfig.setUnimprovedHoursSpentLimit(termination.getUnimprovedHoursSpentLimit());
        terminationConfig.setUnimprovedMinutesSpentLimit(termination.getUnimprovedMinutesSpentLimit());
        terminationConfig.setUnimprovedSecondsSpentLimit(termination.getUnimprovedSecondsSpentLimit());
        terminationConfig.setUnimprovedMillisecondsSpentLimit(termination.getUnimprovedMillisecondsSpentLimit());
        return terminationConfig;
    }
}

