/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.backend.server;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.domain.ScanAnnotatedClassesConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationCompositionStyle;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.PhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;

class ToSolverConfig {
    private SolverConfigModel config;

    public ToSolverConfig(SolverConfigModel config) {
        this.config = config;
    }

    public SolverConfig get() {
        SolverConfig solverConfig = new SolverConfig();
        solverConfig.setScanAnnotatedClassesConfig(new ScanAnnotatedClassesConfig());
        solverConfig.setTerminationConfig(this.create(this.config.getTermination()));
        solverConfig.setScoreDirectorFactoryConfig(this.create(this.config.getScoreDirectorFactoryConfig()));
        solverConfig.setPhaseConfigList(this.create(this.config.getPhaseConfigList()));
        return solverConfig;
    }

    private ScoreDirectorFactoryConfig create(ScoreDirectorFactoryConfigModel scoreDirectorFactoryConfig) {
        if (scoreDirectorFactoryConfig == null) {
            return new ScoreDirectorFactoryConfig();
        }
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig();
        config.setKsessionName(scoreDirectorFactoryConfig.getKSessionName());
        return config;
    }

    private TerminationConfig create(TerminationConfigModel termination) {
        if (termination == null) {
            return new TerminationConfig();
        }
        TerminationConfig terminationConfig = new TerminationConfig();
        if (termination.getTerminationCompositionStyle() != null) {
            terminationConfig.setTerminationCompositionStyle(TerminationCompositionStyle.valueOf((String)termination.getTerminationCompositionStyle().name()));
        }
        terminationConfig.setDaysSpentLimit(termination.getDaysSpentLimit());
        terminationConfig.setHoursSpentLimit(termination.getHoursSpentLimit());
        terminationConfig.setMinutesSpentLimit(termination.getMinutesSpentLimit());
        terminationConfig.setSecondsSpentLimit(termination.getSecondsSpentLimit());
        terminationConfig.setMillisecondsSpentLimit(termination.getMillisecondsSpentLimit());
        terminationConfig.setUnimprovedDaysSpentLimit(termination.getUnimprovedDaysSpentLimit());
        terminationConfig.setUnimprovedHoursSpentLimit(termination.getUnimprovedHoursSpentLimit());
        terminationConfig.setUnimprovedMinutesSpentLimit(termination.getUnimprovedMinutesSpentLimit());
        terminationConfig.setUnimprovedSecondsSpentLimit(termination.getUnimprovedSecondsSpentLimit());
        terminationConfig.setUnimprovedMillisecondsSpentLimit(termination.getUnimprovedMillisecondsSpentLimit());
        terminationConfig.setBestScoreLimit(termination.getBestScoreLimit());
        terminationConfig.setBestScoreFeasible(termination.getBestScoreFeasible());
        terminationConfig.setStepCountLimit(termination.getStepCountLimit());
        terminationConfig.setUnimprovedStepCountLimit(termination.getUnimprovedStepCountLimit());
        terminationConfig.setScoreCalculationCountLimit(termination.getScoreCalculationCountLimit());
        if (termination.getTerminationConfigList() != null) {
            ArrayList<TerminationConfig> nestedTerminationList = new ArrayList<TerminationConfig>();
            for (TerminationConfigModel terminationConfigModel : termination.getTerminationConfigList()) {
                nestedTerminationList.add(this.create(terminationConfigModel));
            }
            terminationConfig.setTerminationConfigList(nestedTerminationList);
        }
        return terminationConfig;
    }

    private List<PhaseConfig> create(List<PhaseConfigModel> phaseConfigList) {
        if (phaseConfigList == null) {
            return new ArrayList<PhaseConfig>();
        }
        ArrayList<PhaseConfig> result = new ArrayList<PhaseConfig>(phaseConfigList.size());
        for (PhaseConfigModel phaseConfigModel : phaseConfigList) {
            if (!(phaseConfigModel instanceof ConstructionHeuristicPhaseConfigModel)) continue;
            ConstructionHeuristicPhaseConfig phaseConfig = new ConstructionHeuristicPhaseConfig();
            ConstructionHeuristicPhaseConfigModel constructionHeuristicPhaseConfigModel = (ConstructionHeuristicPhaseConfigModel)phaseConfigModel;
            if (constructionHeuristicPhaseConfigModel.getConstructionHeuristicType() != null) {
                phaseConfig.setConstructionHeuristicType(ConstructionHeuristicType.valueOf((String)constructionHeuristicPhaseConfigModel.getConstructionHeuristicType().name()));
            }
            result.add((PhaseConfig)phaseConfig);
        }
        return result;
    }
}

