/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.webexamples.cloudbalancing;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpSession;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;

public class CloudBalancingWebAction {
    private static ExecutorService solvingExecutor = Executors.newFixedThreadPool(4);

    public void setup(HttpSession session) {
        this.terminateEarly(session);
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        session.setAttribute("cloudbalancing.solver", (Object)solver);
        CloudBalance unsolvedSolution = new CloudBalancingGenerator(true).createCloudBalance(100, 300);
        session.setAttribute("cloudbalancing.shownSolution", (Object)unsolvedSolution);
    }

    public void solve(HttpSession session) {
        Solver solver = (Solver)session.getAttribute("cloudbalancing.solver");
        CloudBalance unsolvedSolution = (CloudBalance)session.getAttribute("cloudbalancing.shownSolution");
        solver.addEventListener((SolverEventListener)new /* Unavailable Anonymous Inner Class!! */);
        solvingExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void terminateEarly(HttpSession session) {
        Solver solver = (Solver)session.getAttribute("cloudbalancing.solver");
        if (solver != null) {
            solver.terminateEarly();
            session.setAttribute("cloudbalancing.solver", null);
        }
    }
}

