/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.webexamples.vehiclerouting;

import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpSession;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingImporter;

public class VrpWebAction {
    private static ExecutorService solvingExecutor = Executors.newFixedThreadPool(4);

    public void setup(HttpSession session) {
        this.terminateEarly(session);
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        session.setAttribute("vehiclerouting.solver", (Object)solver);
        URL unsolvedSolutionURL = this.getClass().getResource("/org/optaplanner/webexamples/vehiclerouting/A-n33-k6.vrp");
        VehicleRoutingSolution unsolvedSolution = (VehicleRoutingSolution)new VehicleRoutingImporter(true).readSolution(unsolvedSolutionURL);
        session.setAttribute("vehiclerouting.shownSolution", (Object)unsolvedSolution);
    }

    public void solve(HttpSession session) {
        Solver solver = (Solver)session.getAttribute("vehiclerouting.solver");
        VehicleRoutingSolution unsolvedSolution = (VehicleRoutingSolution)session.getAttribute("vehiclerouting.shownSolution");
        solver.addEventListener((SolverEventListener)new /* Unavailable Anonymous Inner Class!! */);
        solvingExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void terminateEarly(HttpSession session) {
        Solver solver = (Solver)session.getAttribute("vehiclerouting.solver");
        if (solver != null) {
            solver.terminateEarly();
            session.setAttribute("vehiclerouting.solver", null);
        }
    }
}

