/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.webexamples.vehiclerouting.rest.service;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.location.Location;
import org.optaplanner.swing.impl.TangoColorFactory;
import org.optaplanner.webexamples.vehiclerouting.rest.cdi.VehicleRoutingSolverManager;
import org.optaplanner.webexamples.vehiclerouting.rest.domain.JsonCustomer;
import org.optaplanner.webexamples.vehiclerouting.rest.domain.JsonMessage;
import org.optaplanner.webexamples.vehiclerouting.rest.domain.JsonVehicleRoute;
import org.optaplanner.webexamples.vehiclerouting.rest.domain.JsonVehicleRoutingSolution;
import org.optaplanner.webexamples.vehiclerouting.rest.service.VehicleRoutingRestService;

public class DefaultVehicleRoutingRestService
implements VehicleRoutingRestService {
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,##0.00");
    @Inject
    private VehicleRoutingSolverManager solverManager;
    @Context
    private HttpServletRequest request;

    public JsonVehicleRoutingSolution getSolution() {
        VehicleRoutingSolution vehicleRoutingSolution = this.solverManager.retrieveOrCreateSolution(this.request.getSession().getId());
        return this.convertToJsonVehicleRoutingSolution(vehicleRoutingSolution);
    }

    protected JsonVehicleRoutingSolution convertToJsonVehicleRoutingSolution(VehicleRoutingSolution vehicleRoutingSolution) {
        Object object;
        Customer customer2;
        JsonVehicleRoutingSolution jsonVehicleRoutingSolution = new JsonVehicleRoutingSolution();
        jsonVehicleRoutingSolution.setName(vehicleRoutingSolution.getName());
        ArrayList<JsonCustomer> arrayList = new ArrayList<JsonCustomer>(vehicleRoutingSolution.getCustomerList().size());
        for (Customer customer2 : vehicleRoutingSolution.getCustomerList()) {
            object = customer2.getLocation();
            arrayList.add(new JsonCustomer(object.getName(), object.getLatitude(), object.getLongitude(), customer2.getDemand()));
        }
        jsonVehicleRoutingSolution.setCustomerList(arrayList);
        ArrayList arrayList2 = new ArrayList(vehicleRoutingSolution.getVehicleList().size());
        customer2 = new TangoColorFactory();
        for (Vehicle vehicle : vehicleRoutingSolution.getVehicleList()) {
            JsonVehicleRoute jsonVehicleRoute = new JsonVehicleRoute();
            Location location = vehicle.getDepot().getLocation();
            jsonVehicleRoute.setDepotLocationName(location.getName());
            jsonVehicleRoute.setDepotLatitude(location.getLatitude());
            jsonVehicleRoute.setDepotLongitude(location.getLongitude());
            jsonVehicleRoute.setCapacity(vehicle.getCapacity());
            Color color = customer2.pickColor((Object)vehicle);
            jsonVehicleRoute.setHexColor(String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue()));
            int n = 0;
            ArrayList<JsonCustomer> arrayList3 = new ArrayList<JsonCustomer>();
            for (Customer customer3 = vehicle.getNextCustomer(); customer3 != null; customer3 = customer3.getNextCustomer()) {
                Location location2 = customer3.getLocation();
                n += customer3.getDemand();
                arrayList3.add(new JsonCustomer(location2.getName(), location2.getLatitude(), location2.getLongitude(), customer3.getDemand()));
            }
            jsonVehicleRoute.setDemandTotal(n);
            jsonVehicleRoute.setCustomerList(arrayList3);
            arrayList2.add(jsonVehicleRoute);
        }
        jsonVehicleRoutingSolution.setVehicleRouteList((List)arrayList2);
        object = vehicleRoutingSolution.getScore();
        jsonVehicleRoutingSolution.setFeasible(Boolean.valueOf(object != null && object.isFeasible()));
        jsonVehicleRoutingSolution.setDistance(vehicleRoutingSolution.getDistanceString(NUMBER_FORMAT));
        return jsonVehicleRoutingSolution;
    }

    public JsonMessage solve() {
        boolean bl = this.solverManager.solve(this.request.getSession().getId());
        return new JsonMessage(bl ? "Solving started." : "Solver was already running.");
    }

    public JsonMessage terminateEarly() {
        boolean bl = this.solverManager.terminateEarly(this.request.getSession().getId());
        return new JsonMessage(bl ? "Solver terminating early." : "Solver was already terminated.");
    }
}

