/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.webexamples.cloudbalancing;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpSession;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;

public class CloudBalancingWebAction {
    private static ExecutorService solvingExecutor = Executors.newFixedThreadPool(4);

    public void setup(HttpSession httpSession) {
        this.terminateEarly(httpSession);
        SolverFactory solverFactory = SolverFactory.createFromXmlResource((String)"org/optaplanner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        httpSession.setAttribute("cloudbalancing.solver", (Object)solver);
        CloudBalance cloudBalance = new CloudBalancingGenerator(true).createCloudBalance(100, 300);
        httpSession.setAttribute("cloudbalancing.shownSolution", (Object)cloudBalance);
    }

    public void solve(HttpSession httpSession) {
        Solver solver = (Solver)httpSession.getAttribute("cloudbalancing.solver");
        CloudBalance cloudBalance = (CloudBalance)httpSession.getAttribute("cloudbalancing.shownSolution");
        solver.addEventListener((SolverEventListener)new /* Unavailable Anonymous Inner Class!! */);
        solvingExecutor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void terminateEarly(HttpSession httpSession) {
        Solver solver = (Solver)httpSession.getAttribute("cloudbalancing.solver");
        if (solver != null) {
            solver.terminateEarly();
            httpSession.setAttribute("cloudbalancing.solver", null);
        }
    }
}

