/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.webexamples.vehiclerouting.rest.cdi;

import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingImporter;

@ApplicationScoped
public class VehicleRoutingSolverManager
implements Serializable {
    private static final String SOLVER_CONFIG = "org/optaplanner/examples/vehiclerouting/solver/vehicleRoutingSolverConfig.xml";
    private static final String IMPORT_DATASET = "/org/optaplanner/webexamples/vehiclerouting/belgium-road-time-n50-k10.vrp";
    private SolverFactory<VehicleRoutingSolution> solverFactory;
    private ExecutorService executor;
    private Map<String, VehicleRoutingSolution> sessionSolutionMap;
    private Map<String, Solver<VehicleRoutingSolution>> sessionSolverMap;

    @PostConstruct
    public synchronized void init() {
        this.solverFactory = SolverFactory.createFromXmlResource((String)SOLVER_CONFIG);
        this.solverFactory.getSolverConfig().setTerminationConfig(new TerminationConfig().withMinutesSpentLimit(Long.valueOf(2L)));
        this.executor = Executors.newFixedThreadPool(2);
        this.sessionSolutionMap = new ConcurrentHashMap();
        this.sessionSolverMap = new ConcurrentHashMap();
    }

    @PreDestroy
    public synchronized void destroy() {
        for (Solver solver : this.sessionSolverMap.values()) {
            solver.terminateEarly();
        }
        this.executor.shutdown();
    }

    public synchronized VehicleRoutingSolution retrieveOrCreateSolution(String string) {
        VehicleRoutingSolution vehicleRoutingSolution = (VehicleRoutingSolution)this.sessionSolutionMap.get(string);
        if (vehicleRoutingSolution == null) {
            URL uRL = this.getClass().getResource(IMPORT_DATASET);
            if (uRL == null) {
                throw new IllegalArgumentException("The IMPORT_DATASET (/org/optaplanner/webexamples/vehiclerouting/belgium-road-time-n50-k10.vrp) is not a valid classpath resource.");
            }
            vehicleRoutingSolution = (VehicleRoutingSolution)new VehicleRoutingImporter().readSolution(uRL);
            this.sessionSolutionMap.put(string, vehicleRoutingSolution);
        }
        return vehicleRoutingSolution;
    }

    public synchronized boolean solve(String string) {
        Solver solver = this.solverFactory.buildSolver();
        solver.addEventListener(bestSolutionChangedEvent -> {
            VehicleRoutingSolution vehicleRoutingSolution = (VehicleRoutingSolution)bestSolutionChangedEvent.getNewBestSolution();
            VehicleRoutingSolverManager vehicleRoutingSolverManager = this;
            synchronized (vehicleRoutingSolverManager) {
                this.sessionSolutionMap.put(string, vehicleRoutingSolution);
            }
        });
        if (this.sessionSolverMap.containsKey(string)) {
            return false;
        }
        this.sessionSolverMap.put(string, solver);
        VehicleRoutingSolution vehicleRoutingSolution = this.retrieveOrCreateSolution(string);
        this.executor.submit(() -> {
            VehicleRoutingSolution vehicleRoutingSolution2 = (VehicleRoutingSolution)solver.solve((Object)vehicleRoutingSolution);
            VehicleRoutingSolverManager vehicleRoutingSolverManager = this;
            synchronized (vehicleRoutingSolverManager) {
                this.sessionSolutionMap.put(string, vehicleRoutingSolution2);
                this.sessionSolverMap.remove(string);
            }
        });
        return true;
    }

    public synchronized boolean terminateEarly(String string) {
        Solver solver = (Solver)this.sessionSolverMap.remove(string);
        if (solver != null) {
            solver.terminateEarly();
            return true;
        }
        return false;
    }
}

