/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.models.datamodel.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.junit.Assert;
import org.junit.Test;
import org.optaplanner.workbench.models.datamodel.rule.AbstractActionConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.AbstractActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionBendableSoftConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionHardConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMediumConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableBigDecimalMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableLongMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintBendableMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardMediumSoftMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionMultiConstraintHardSoftMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionSimpleConstraintMatch;
import org.optaplanner.workbench.models.datamodel.rule.ActionSoftConstraintMatch;

public class ActionConstraintMatchTest {
    @Test
    public void extractInterpolationVariablesActionHardConstraintMatch() {
        ActionHardConstraintMatch constraintMatch = new ActionHardConstraintMatch("foo bar @{var1}");
        this.extractInterpolationVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void extractInterpolationVariablesActionSoftConstraintMatch() {
        ActionSoftConstraintMatch constraintMatch = new ActionSoftConstraintMatch("foo bar @{var1}");
        this.extractInterpolationVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void extractInterpolationVariablesActionMediumConstraintMatch() {
        ActionMediumConstraintMatch constraintMatch = new ActionMediumConstraintMatch("foo bar @{var1}");
        this.extractInterpolationVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void extractInterpolationVariablesActionSimpleConstraintMatch() {
        ActionSimpleConstraintMatch constraintMatch = new ActionSimpleConstraintMatch("foo bar @{var1}");
        this.extractInterpolationVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void extractInterpolationVariablesActionBendableHardConstraintMatch() {
        ActionBendableHardConstraintMatch constraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        this.extractInterpolationVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void extractInterpolationVariablesActionBendableSoftConstraintMatch() {
        ActionBendableSoftConstraintMatch constraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var1}");
        this.extractInterpolationVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    private void extractInterpolationVariablesAbstractActionConstraintMatch(AbstractActionConstraintMatch constraintMatch) {
        Collection interpolationVariables = constraintMatch.extractInterpolationVariables();
        Assert.assertEquals((long)1L, (long)interpolationVariables.size());
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var1", "Object")));
    }

    @Test
    public void extractInterpolationVariablesActionMultiConstraintHardSoftMatch() {
        ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch("foo bar @{var1}");
        ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch("foo bar @{var2}");
        ActionMultiConstraintHardSoftMatch multiConstraintHardSoftMatch = new ActionMultiConstraintHardSoftMatch(hardConstraintMatch, softConstraintMatch);
        Collection interpolationVariables = multiConstraintHardSoftMatch.extractInterpolationVariables();
        Assert.assertEquals((long)2L, (long)interpolationVariables.size());
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var1", "Object")));
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var2", "Object")));
    }

    @Test
    public void extractInterpolationVariablesActionMultiConstraintHardMediumSoftMatch() {
        ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch("foo bar @{var1}");
        ActionMediumConstraintMatch mediumConstraintMatch = new ActionMediumConstraintMatch("foo bar @{var2}");
        ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch("foo bar @{var3}");
        ActionMultiConstraintHardMediumSoftMatch multiConstraintHardSoftMatch = new ActionMultiConstraintHardMediumSoftMatch(hardConstraintMatch, mediumConstraintMatch, softConstraintMatch);
        Collection interpolationVariables = multiConstraintHardSoftMatch.extractInterpolationVariables();
        Assert.assertEquals((long)3L, (long)interpolationVariables.size());
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var1", "Object")));
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var2", "Object")));
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var3", "Object")));
    }

    @Test
    public void extractInterpolationVariablesActionMultiConstraintBendableMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var2}");
        ActionMultiConstraintBendableMatch multiConstraintBendableMatch = new ActionMultiConstraintBendableMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.extractInterpolationVariablesAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)multiConstraintBendableMatch);
    }

    @Test
    public void extractInterpolationVariablesActionMultiConstraintBendableLongMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var2}");
        ActionMultiConstraintBendableLongMatch multiConstraintBendableMatch = new ActionMultiConstraintBendableLongMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.extractInterpolationVariablesAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)multiConstraintBendableMatch);
    }

    @Test
    public void extractInterpolationVariablesActionMultiConstraintBendableBigDecimalMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var2}");
        ActionMultiConstraintBendableBigDecimalMatch multiConstraintBendableMatch = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.extractInterpolationVariablesAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)multiConstraintBendableMatch);
    }

    private void extractInterpolationVariablesAbstractActionMultiConstraintBendableMatch(AbstractActionMultiConstraintBendableMatch constraintMatch) {
        Collection interpolationVariables = constraintMatch.extractInterpolationVariables();
        Assert.assertEquals((long)2L, (long)interpolationVariables.size());
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var1", "Object")));
        Assert.assertTrue((boolean)interpolationVariables.contains(new InterpolationVariable("var2", "Object")));
    }

    @Test
    public void substituteTemplateVariablesActionHardConstraintMatch() {
        ActionHardConstraintMatch constraintMatch = new ActionHardConstraintMatch("foo bar @{var1}");
        this.substituteTemplateVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void substituteTemplateVariablesActionSoftConstraintMatch() {
        ActionSoftConstraintMatch constraintMatch = new ActionSoftConstraintMatch("foo bar @{var1}");
        this.substituteTemplateVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void substituteTemplateVariablesActionMediumConstraintMatch() {
        ActionMediumConstraintMatch constraintMatch = new ActionMediumConstraintMatch("foo bar @{var1}");
        this.substituteTemplateVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void substituteTemplateVariablesActionSimpleConstraintMatch() {
        ActionSimpleConstraintMatch constraintMatch = new ActionSimpleConstraintMatch("foo bar @{var1}");
        constraintMatch.substituteTemplateVariables(this.getKeyToValueFunction());
        this.substituteTemplateVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void substituteTemplateVariablesActionBendableHardConstraintMatch() {
        ActionBendableHardConstraintMatch constraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        this.substituteTemplateVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void substituteTemplateVariablesActionBendableSoftConstraintMatch() {
        ActionBendableSoftConstraintMatch constraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var1}");
        this.substituteTemplateVariablesAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    private void substituteTemplateVariablesAbstractActionConstraintMatch(AbstractActionConstraintMatch constraintMatch) {
        constraintMatch.substituteTemplateVariables(this.getKeyToValueFunction());
        Assert.assertEquals((Object)"foo bar val1", (Object)constraintMatch.getConstraintMatch());
    }

    @Test
    public void substituteTemplateVariablesActionMultiConstraintHardSoftMatch() {
        ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch("foo bar @{var1}");
        ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch("foo bar @{var2}");
        ActionMultiConstraintHardSoftMatch multiConstraintHardSoftMatch = new ActionMultiConstraintHardSoftMatch(hardConstraintMatch, softConstraintMatch);
        multiConstraintHardSoftMatch.substituteTemplateVariables(this.getKeyToValueFunction());
        Assert.assertEquals((Object)"foo bar val1", (Object)multiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"foo bar val2", (Object)multiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void substituteTemplateVariablesActionMultiConstraintHardMediumSoftMatch() {
        ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch("foo bar @{var1}");
        ActionMediumConstraintMatch mediumConstraintMatch = new ActionMediumConstraintMatch("foo bar @{var2}");
        ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch("foo bar @{var3}");
        ActionMultiConstraintHardMediumSoftMatch multiConstraintHardSoftMatch = new ActionMultiConstraintHardMediumSoftMatch(hardConstraintMatch, mediumConstraintMatch, softConstraintMatch);
        multiConstraintHardSoftMatch.substituteTemplateVariables(this.getKeyToValueFunction());
        Assert.assertEquals((Object)"foo bar val1", (Object)multiConstraintHardSoftMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"foo bar val2", (Object)multiConstraintHardSoftMatch.getActionMediumConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"foo bar val3", (Object)multiConstraintHardSoftMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void substituteTemplateVariablesActionMultiConstraintBendableMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var2}");
        ActionMultiConstraintBendableMatch multiConstraintBendableMatch = new ActionMultiConstraintBendableMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.substituteTemplateVariablesAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)multiConstraintBendableMatch);
    }

    @Test
    public void substituteTemplateVariablesActionMultiConstraintBendableLongMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var2}");
        ActionMultiConstraintBendableLongMatch multiConstraintBendableMatch = new ActionMultiConstraintBendableLongMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.substituteTemplateVariablesAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)multiConstraintBendableMatch);
    }

    @Test
    public void substituteTemplateVariablesActionMultiConstraintBendableBigDecimalMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "foo bar @{var1}");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "foo bar @{var2}");
        ActionMultiConstraintBendableBigDecimalMatch multiConstraintBendableMatch = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.substituteTemplateVariablesAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)multiConstraintBendableMatch);
    }

    private void substituteTemplateVariablesAbstractActionMultiConstraintBendableMatch(AbstractActionMultiConstraintBendableMatch constraintMatch) {
        constraintMatch.substituteTemplateVariables(this.getKeyToValueFunction());
        Assert.assertNotNull((Object)constraintMatch.getActionBendableHardConstraintMatches());
        Assert.assertEquals((Object)"foo bar val1", (Object)((ActionBendableHardConstraintMatch)constraintMatch.getActionBendableHardConstraintMatches().get(0)).getConstraintMatch());
        Assert.assertNotNull((Object)constraintMatch.getActionBendableSoftConstraintMatches());
        Assert.assertEquals((Object)"foo bar val2", (Object)((ActionBendableSoftConstraintMatch)constraintMatch.getActionBendableSoftConstraintMatches().get(0)).getConstraintMatch());
    }

    private Function<String, String> getKeyToValueFunction() {
        return s -> {
            switch (s) {
                case "var1": {
                    return "val1";
                }
                case "var2": {
                    return "val2";
                }
                case "var3": {
                    return "val3";
                }
            }
            throw new IllegalArgumentException("Undefined variable " + s);
        };
    }

    @Test
    public void cloneIActionBendableHardConstraintMatchPlugin() {
        ActionBendableHardConstraintMatch constraintMatch = new ActionBendableHardConstraintMatch(0, "test");
        this.cloneIActionAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void cloneIActionBendableSoftConstraintMatchPlugin() {
        ActionBendableSoftConstraintMatch constraintMatch = new ActionBendableSoftConstraintMatch(0, "test");
        this.cloneIActionAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void cloneIActionHardConstraintMatchPlugin() {
        ActionHardConstraintMatch constraintMatch = new ActionHardConstraintMatch("test");
        this.cloneIActionAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void cloneIActionSoftConstraintMatchPlugin() {
        ActionSoftConstraintMatch constraintMatch = new ActionSoftConstraintMatch("test");
        this.cloneIActionAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void cloneIActionMediumConstraintMatchPlugin() {
        ActionMediumConstraintMatch constraintMatch = new ActionMediumConstraintMatch("test");
        this.cloneIActionAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    @Test
    public void cloneIActionSimpleConstraintMatchPlugin() {
        ActionSimpleConstraintMatch constraintMatch = new ActionSimpleConstraintMatch("test");
        this.cloneIActionAbstractActionConstraintMatch((AbstractActionConstraintMatch)constraintMatch);
    }

    private void cloneIActionAbstractActionConstraintMatch(AbstractActionConstraintMatch constraintMatch) {
        IAction constraintMatchClone = (IAction)constraintMatch.cloneTemplateAware();
        Assert.assertNotNull((Object)constraintMatchClone);
        Assert.assertNotSame((Object)constraintMatchClone, (Object)constraintMatch);
        Assert.assertEquals((Object)"test", (Object)constraintMatch.getConstraintMatch());
    }

    @Test
    public void cloneIActionMultiConstraintBendableBigDecimalMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "hard");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "soft");
        ActionMultiConstraintBendableBigDecimalMatch constraintMatch = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.cloneIActionAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)constraintMatch);
    }

    @Test
    public void cloneIActionMultiConstraintBendableLongMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "hard");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "soft");
        ActionMultiConstraintBendableLongMatch constraintMatch = new ActionMultiConstraintBendableLongMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.cloneIActionAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)constraintMatch);
    }

    @Test
    public void cloneIActionMultiConstraintBendableMatch() {
        ActionBendableHardConstraintMatch bendableHardConstraintMatch = new ActionBendableHardConstraintMatch(0, "hard");
        ActionBendableSoftConstraintMatch bendableSoftConstraintMatch = new ActionBendableSoftConstraintMatch(0, "soft");
        ActionMultiConstraintBendableMatch constraintMatch = new ActionMultiConstraintBendableMatch(Arrays.asList(bendableHardConstraintMatch), Arrays.asList(bendableSoftConstraintMatch));
        this.cloneIActionAbstractActionMultiConstraintBendableMatch((AbstractActionMultiConstraintBendableMatch)constraintMatch);
    }

    private void cloneIActionAbstractActionMultiConstraintBendableMatch(AbstractActionMultiConstraintBendableMatch constraintMatch) {
        IAction constraintMatchClone = (IAction)constraintMatch.cloneTemplateAware();
        Assert.assertNotNull((Object)constraintMatchClone);
        Assert.assertNotSame((Object)constraintMatchClone, (Object)constraintMatch);
        Assert.assertNotNull((Object)constraintMatch.getActionBendableHardConstraintMatches());
        Assert.assertNotNull((Object)constraintMatch.getActionBendableSoftConstraintMatches());
        Assert.assertEquals((Object)"hard", (Object)((ActionBendableHardConstraintMatch)constraintMatch.getActionBendableHardConstraintMatches().get(0)).getConstraintMatch());
        Assert.assertEquals((Object)"soft", (Object)((ActionBendableSoftConstraintMatch)constraintMatch.getActionBendableSoftConstraintMatches().get(0)).getConstraintMatch());
    }

    @Test
    public void cloneIActionMultiConstraintHardMediumSoftMatch() {
        ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch("hard");
        ActionMediumConstraintMatch mediumConstraintMatch = new ActionMediumConstraintMatch("medium");
        ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch("soft");
        ActionMultiConstraintHardMediumSoftMatch constraintMatch = new ActionMultiConstraintHardMediumSoftMatch(hardConstraintMatch, mediumConstraintMatch, softConstraintMatch);
        IAction constraintMatchClone = (IAction)constraintMatch.cloneTemplateAware();
        Assert.assertNotNull((Object)constraintMatchClone);
        Assert.assertNotSame((Object)constraintMatchClone, (Object)constraintMatch);
        Assert.assertNotNull((Object)constraintMatch.getActionHardConstraintMatch());
        Assert.assertNotNull((Object)constraintMatch.getActionMediumConstraintMatch());
        Assert.assertNotNull((Object)constraintMatch.getActionSoftConstraintMatch());
        Assert.assertEquals((Object)"hard", (Object)constraintMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"medium", (Object)constraintMatch.getActionMediumConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"soft", (Object)constraintMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void cloneIActionMultiConstraintHardSoftMatch() {
        ActionHardConstraintMatch hardConstraintMatch = new ActionHardConstraintMatch("hard");
        ActionSoftConstraintMatch softConstraintMatch = new ActionSoftConstraintMatch("soft");
        ActionMultiConstraintHardSoftMatch constraintMatch = new ActionMultiConstraintHardSoftMatch(hardConstraintMatch, softConstraintMatch);
        IAction constraintMatchClone = (IAction)constraintMatch.cloneTemplateAware();
        Assert.assertNotNull((Object)constraintMatchClone);
        Assert.assertNotSame((Object)constraintMatchClone, (Object)constraintMatch);
        Assert.assertNotNull((Object)constraintMatch.getActionHardConstraintMatch());
        Assert.assertNotNull((Object)constraintMatch.getActionSoftConstraintMatch());
        Assert.assertEquals((Object)"hard", (Object)constraintMatch.getActionHardConstraintMatch().getConstraintMatch());
        Assert.assertEquals((Object)"soft", (Object)constraintMatch.getActionSoftConstraintMatch().getConstraintMatch());
    }

    @Test
    public void marshalActionSoftConstraintMatch() {
        ActionSoftConstraintMatch action = new ActionSoftConstraintMatch("-1");
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addSoftConstraintMatch(kcontext, -1)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionBendableSoftConstraintMatch() {
        ActionBendableSoftConstraintMatch action = new ActionBendableSoftConstraintMatch(1, "-1");
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addSoftConstraintMatch(kcontext, 1, -1)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMediumConstraintMatch() {
        ActionMediumConstraintMatch action = new ActionMediumConstraintMatch("-1");
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addMediumConstraintMatch(kcontext, -1)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintHardSoftMatch() {
        ActionMultiConstraintHardSoftMatch action = new ActionMultiConstraintHardSoftMatch(new ActionHardConstraintMatch("-1"), new ActionSoftConstraintMatch("-2"));
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, -1, -2)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintHardMediumSoftMatch() {
        ActionMultiConstraintHardMediumSoftMatch action = new ActionMultiConstraintHardMediumSoftMatch(new ActionHardConstraintMatch("-1"), new ActionMediumConstraintMatch("-2"), new ActionSoftConstraintMatch("-3"));
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, -1, -2, -3)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintBendableMatch() {
        ActionMultiConstraintBendableMatch action = new ActionMultiConstraintBendableMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1"), new ActionBendableHardConstraintMatch(1, "-2")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3"), new ActionBendableSoftConstraintMatch(1, "-4")));
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, new int[] {-1, -2}, new int[] {-3, -4})", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintBendableLongMatch() {
        ActionMultiConstraintBendableLongMatch action = new ActionMultiConstraintBendableLongMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "-1l"), new ActionBendableHardConstraintMatch(1, "-2l")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "-3l"), new ActionBendableSoftConstraintMatch(1, "-4l")));
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, new long[] {-1l, -2l}, new long[] {-3l, -4l})", (Object)marshaledAction);
    }

    @Test
    public void marshalActionMultiConstraintBendableBigDecimalMatch() {
        ActionMultiConstraintBendableBigDecimalMatch action = new ActionMultiConstraintBendableBigDecimalMatch(Arrays.asList(new ActionBendableHardConstraintMatch(0, "new java.math.BigDecimal(-1)"), new ActionBendableHardConstraintMatch(1, "new java.math.BigDecimal(-2)")), Arrays.asList(new ActionBendableSoftConstraintMatch(0, "new java.math.BigDecimal(-3)"), new ActionBendableSoftConstraintMatch(1, "new java.math.BigDecimal(-4)")));
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addMultiConstraintMatch(kcontext, new java.math.BigDecimal[] {new java.math.BigDecimal(-1), new java.math.BigDecimal(-2)}, new java.math.BigDecimal[] {new java.math.BigDecimal(-3), new java.math.BigDecimal(-4)})", (Object)marshaledAction);
    }

    @Test
    public void marshalActionSimpleConstraintMatch() {
        ActionSimpleConstraintMatch action = new ActionSimpleConstraintMatch("-1");
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addConstraintMatch(kcontext, -1)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionHardConstraintMatch() {
        ActionHardConstraintMatch action = new ActionHardConstraintMatch("-1");
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addHardConstraintMatch(kcontext, -1)", (Object)marshaledAction);
    }

    @Test
    public void marshalActionBendableHardConstraintMatch() {
        ActionBendableHardConstraintMatch action = new ActionBendableHardConstraintMatch(1, "-1");
        String marshaledAction = action.getStringRepresentation();
        Assert.assertEquals((Object)"scoreHolder.addHardConstraintMatch(kcontext, 1, -1)", (Object)marshaledAction);
    }
}

