/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.domain.common;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.optaplanner.core.api.domain.lookup.PlanningId;

@MappedSuperclass
public abstract class AbstractPersistable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @PlanningId
    private Long id;
    @NotNull
    private Integer tenantId;
    @Version
    private Long version;

    public AbstractPersistable() {
    }

    protected AbstractPersistable(Integer tenantId) {
        this(null, tenantId);
    }

    protected AbstractPersistable(Long id, Integer tenantId) {
        this.id = id;
        this.tenantId = tenantId;
    }

    protected AbstractPersistable(AbstractPersistable other) {
        this.id = other.id;
        this.tenantId = other.tenantId;
        this.version = other.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractPersistable other = (AbstractPersistable)o;
        return !(this.id == null ? other.getId() != null : !this.id.equals(other.getId()));
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "-" + this.id + "]";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Integer tenantId) {
        this.tenantId = tenantId;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
}

