/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.employeerostering.service.shift;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import org.optaweb.employeerostering.domain.employee.Employee;
import org.optaweb.employeerostering.domain.shift.Shift;
import org.optaweb.employeerostering.domain.spot.Spot;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ShiftRepository
extends JpaRepository<Shift, Long> {
    @Query(value="select distinct sa from Shift sa left join fetch sa.spot s left join fetch sa.rotationEmployee re left join fetch sa.employee e where sa.tenantId = :tenantId order by sa.startDateTime, s.name, e.name")
    public List<Shift> findAllByTenantId(@Param(value="tenantId") Integer var1);

    @Modifying(flushAutomatically=true, clearAutomatically=true)
    @Query(value="delete from Shift s where s.tenantId = :tenantId")
    public void deleteForTenant(@Param(value="tenantId") Integer var1);

    @Query(value="select distinct sa from Shift sa left join fetch sa.spot s left join fetch sa.rotationEmployee re left join fetch sa.employee e where sa.tenantId = :tenantId and sa.spot IN :spotSet and sa.endDateTime >= :startDateTime and sa.startDateTime < :endDateTime order by sa.startDateTime, s.name, e.name")
    public List<Shift> filterWithSpots(@Param(value="tenantId") Integer var1, @Param(value="spotSet") Set<Spot> var2, @Param(value="startDateTime") OffsetDateTime var3, @Param(value="endDateTime") OffsetDateTime var4);

    @Query(value="select distinct sa from Shift sa left join fetch sa.spot s left join fetch sa.rotationEmployee re left join fetch sa.employee e where sa.tenantId = :tenantId and sa.employee IN :employeeSet and sa.endDateTime >= :startDateTime and sa.startDateTime < :endDateTime order by sa.startDateTime, s.name, e.name")
    public List<Shift> filterWithEmployees(@Param(value="tenantId") Integer var1, @Param(value="employeeSet") Set<Employee> var2, @Param(value="startDateTime") OffsetDateTime var3, @Param(value="endDateTime") OffsetDateTime var4);
}

